/*
 * Decompiled with CFR 0.152.
 */
package org.pfsw.text;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import org.pfsw.bif.exceptions.IORuntimeException;
import org.pfsw.bif.text.ICharsets;
import org.pfsw.bif.text.IStringRepresentation;
import org.pfsw.text.NewLine;
import org.pfsw.text.StringUtil;

public class FormattedTextWriter
implements Appendable,
Closeable {
    private final Appendable output;
    private final AtomicBoolean isOpen = new AtomicBoolean(true);
    private int indentLevel = 0;
    private int indentSize = 2;
    private String newline = NewLine.CURRENT_OS.asString();
    private boolean onNewLine = true;

    public static FormattedTextWriter create(Appendable output) {
        return new FormattedTextWriter(output);
    }

    public static FormattedTextWriter create(Appendable output, int indentSize) {
        FormattedTextWriter textWriter = FormattedTextWriter.create(output);
        textWriter.setIndentSize(indentSize);
        return textWriter;
    }

    public static FormattedTextWriter create(Appendable output, int indentSize, NewLine newLine) {
        FormattedTextWriter textWriter = FormattedTextWriter.create(output, indentSize);
        textWriter.setNewline(newLine.asString());
        return textWriter;
    }

    public static FormattedTextWriter create(File outputFile, Charset charEncoding) throws IOException {
        return new FormattedTextWriter(outputFile, charEncoding);
    }

    public static FormattedTextWriter create(File outputFile) throws IOException {
        return new FormattedTextWriter(outputFile);
    }

    public FormattedTextWriter(Appendable output) {
        if (output == null) {
            throw new IllegalArgumentException("output must not be null");
        }
        this.output = output;
    }

    public FormattedTextWriter(File outputFile, Charset charEncoding) throws IOException {
        if (outputFile == null) {
            throw new IllegalArgumentException("outputFile must not be null");
        }
        if (charEncoding == null) {
            throw new IllegalArgumentException("charEncoding must not be null");
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), charEncoding);
        this.output = writer;
    }

    public FormattedTextWriter(File outputFile) throws IOException {
        this(outputFile, ICharsets.UTF_8);
    }

    public FormattedTextWriter write(String text, Object ... args) {
        this.checkOpenState();
        if (this.indentationRequired()) {
            this.writeIndentation();
        }
        try {
            this.getOutput().append(String.format(text, args));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return this;
    }

    public FormattedTextWriter write(IStringRepresentation object) {
        return this.write(object.asString(), new Object[0]);
    }

    public FormattedTextWriter writeln(String text, Object ... args) {
        this.write(text, args);
        this.newLine();
        return this;
    }

    public FormattedTextWriter writeln(IStringRepresentation object) {
        return this.writeln(object.asString(), new Object[0]);
    }

    public FormattedTextWriter newLine() {
        this.write(this.getNewline(), new Object[0]);
        this.onNewLine = true;
        return this;
    }

    public FormattedTextWriter indent() {
        ++this.indentLevel;
        return this;
    }

    public FormattedTextWriter outdent() {
        if (this.indentLevel > 0) {
            --this.indentLevel;
        }
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        this.write(String.valueOf(c), new Object[0]);
        return this;
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        this.write(((Object)csq).toString(), new Object[0]);
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        this.write(((Object)csq.subSequence(start, end)).toString(), new Object[0]);
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this.getOutput() instanceof Closeable) {
            Closeable closeable = (Closeable)((Object)this.getOutput());
            closeable.close();
        }
        this.isOpen.set(false);
    }

    public int getIndentSize() {
        return this.indentSize;
    }

    public FormattedTextWriter setIndentSize(int indentSize) {
        if (indentSize < 0 || indentSize > this.getMaxIndentSize()) {
            throw new IllegalArgumentException(String.format("Invalid indentation size %d. It must be in the range of 0..%d", indentSize, this.getMaxIndentSize()));
        }
        this.indentSize = indentSize;
        return this;
    }

    public String getNewline() {
        return this.newline;
    }

    public FormattedTextWriter setNewline(String newline) {
        if (newline == null) {
            throw new IllegalArgumentException("newline must not be null");
        }
        this.newline = newline;
        return this;
    }

    public int getIndentLevel() {
        return this.indentLevel;
    }

    protected Appendable getOutput() {
        return this.output;
    }

    protected int getMaxIndentSize() {
        return 20;
    }

    protected boolean indentationRequired() {
        return this.onNewLine && this.getNumberOfIndentSpaces() > 0;
    }

    protected int getNumberOfIndentSpaces() {
        return this.getIndentLevel() * this.getIndentSize();
    }

    protected FormattedTextWriter writeIndentation() {
        this.onNewLine = false;
        int numSpaces = this.getNumberOfIndentSpaces();
        if (numSpaces > 0) {
            this.write(StringUtil.current().repeat(' ', numSpaces), new Object[0]);
        }
        return this;
    }

    protected void checkOpenState() {
        if (!this.isOpen.get()) {
            throw new IllegalStateException("This writer has been closed, no further data appending to it allowed.");
        }
    }
}

