/*
 * Decompiled with CFR 0.152.
 */
package org.pfsw.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pfsw.text.StringUtil;

public class CommandLineArguments {
    protected static final String STRING_DELIMITER = "\"";
    protected static final String DEFAULT_SWITCH_INDICATOR = "-";
    protected static final String QUOTE = "'";
    private String[] arguments = null;
    private String switchIndicator = "-";
    private Map<String, String[]> optionsWithValues = null;
    private boolean switchAndValuesMustBeSeparated = true;
    private boolean supportQuotedArguments = false;

    public static CommandLineArguments create(String ... options) {
        return new CommandLineArguments(options);
    }

    public CommandLineArguments() {
        this(null, DEFAULT_SWITCH_INDICATOR);
    }

    public CommandLineArguments(boolean switchAndValuesMustBeSeparated) {
        this(null, DEFAULT_SWITCH_INDICATOR, switchAndValuesMustBeSeparated);
    }

    public CommandLineArguments(String[] args) {
        this(args, DEFAULT_SWITCH_INDICATOR);
    }

    public CommandLineArguments(String[] args, boolean switchAndValuesMustBeSeparated) {
        this(args, DEFAULT_SWITCH_INDICATOR, switchAndValuesMustBeSeparated);
    }

    public CommandLineArguments(String[] args, String switchIndicator) {
        this(args, switchIndicator, true);
    }

    public CommandLineArguments(String[] args, String switchIndicator, boolean switchAndValuesMustBeSeparated) {
        this(args, switchIndicator, switchAndValuesMustBeSeparated, false);
    }

    protected CommandLineArguments(String[] args, String switchIndicator, boolean switchAndValuesMustBeSeparated, boolean supportQuotedArguments) {
        this.setSwitchAndValuesMustBeSeparated(switchAndValuesMustBeSeparated);
        if (args == null) {
            this.arguments(StringUtil.EMPTY_STRING_ARRAY);
        } else {
            this.arguments(this.strUtil().copy(args));
        }
        this.supportQuotedArguments = supportQuotedArguments;
        if (switchIndicator != null) {
            this.setSwitchIndicator(switchIndicator);
        } else {
            this.init();
        }
    }

    public String toString() {
        return this.strUtil().asString(this.arguments(), " ");
    }

    public boolean isOptionSet(String option) {
        if (option == null) {
            throw new IllegalArgumentException("option is null");
        }
        return this.isOption(option) && this.findOptionValue(option) != null;
    }

    public boolean containsArgument(String argName) {
        if (argName == null) {
            throw new IllegalArgumentException("argName is null");
        }
        return this.strUtil().contains(this.getArguments(), argName);
    }

    public boolean containsAny(String ... argNames) {
        for (String name : argNames) {
            if (!this.containsArgument(name)) continue;
            return true;
        }
        return false;
    }

    public String getArgumentValue(String option, String defaultValue) {
        String value = this.getArgumentValue(option);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public String getArgumentValue(String option) {
        if (option == null) {
            throw new IllegalArgumentException("option is null");
        }
        return this.findOptionValue(option);
    }

    public String getFirstFoundValue(String ... options) {
        if (this.strUtil().isNullOrEmpty(options)) {
            throw new IllegalArgumentException("No option specified.");
        }
        for (String option : options) {
            String value = this.findOptionValue(option);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public String[] getArgumentValues(String option) {
        if (option == null) {
            throw new IllegalArgumentException("option is null");
        }
        return this.findValues(option);
    }

    public String[] getArgumentValues(String option, String ... defaultValues) {
        String[] values = this.getArgumentValues(option);
        if (values == null) {
            return defaultValues;
        }
        return values;
    }

    public String[] getOptionValues(String option) {
        if (option == null) {
            throw new IllegalArgumentException("option is null");
        }
        String[] args = this.getArguments();
        int index = this.strUtil().indexOf(args, option);
        if (index < 0) {
            return null;
        }
        ArrayList<String> strings = new ArrayList<String>(args.length);
        for (int i = index + 1; i < args.length && !args[i].startsWith(this.getSwitchIndicator()); ++i) {
            strings.add(args[i]);
        }
        if (strings.isEmpty()) {
            return StringUtil.EMPTY_STRING_ARRAY;
        }
        return this.strUtil().asStrings(strings);
    }

    public void addOption(String option) {
        if (option == null) {
            throw new IllegalArgumentException("option is null");
        }
        if (!this.isOptionSet(option)) {
            String[] newArgs = this.strUtil().append(this.arguments(), option);
            this.arguments(newArgs);
            this.init();
        }
    }

    public void addOptionWithArgument(String option, String argument) {
        if (option == null) {
            throw new IllegalArgumentException("option is null");
        }
        if (argument == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isOptionSet(option)) {
            String[] add = new String[]{option, argument};
            String[] newArgs = this.strUtil().append(this.arguments(), add);
            this.arguments(newArgs);
            this.init();
        }
    }

    public void removeOption(String option) {
        if (option == null) {
            throw new IllegalArgumentException("option is null");
        }
        this.arguments(this.strUtil().remove(this.arguments(), option));
        this.init();
    }

    public void removeOptionWithArgument(String option) {
        if (option == null) {
            throw new IllegalArgumentException("option is null");
        }
        String[] args = this.arguments();
        int index = this.strUtil().indexOf(args, option);
        if (index < 0) {
            return;
        }
        args[index] = null;
        if (++index < this.arguments().length && !this.isOption(args[index])) {
            args[index] = null;
        }
        this.arguments(this.strUtil().removeNull(this.arguments()));
        this.init();
    }

    public CommandLineArguments copy() {
        CommandLineArguments aCopy = new CommandLineArguments(this.strUtil().copy(this.arguments()), this.getSwitchIndicator(), this.getSwitchAndValuesMustBeSeparated(), this.getSupportQuotedArguments());
        return aCopy;
    }

    public String getSwitchIndicator() {
        return this.switchIndicator();
    }

    public void setSwitchIndicator(String newValue) {
        this.switchIndicator(newValue);
        this.init();
    }

    public int size() {
        return this.arguments().length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String[] getArguments() {
        return this.copyOfArguments();
    }

    public String getArgumentAt(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        return this.unquotedIfSupported(this.arguments()[index]);
    }

    public boolean getSupportQuotedArguments() {
        return this.supportQuotedArguments;
    }

    public void setSupportQuotedArguments(boolean supportThem) {
        if (this.supportQuotedArguments != supportThem) {
            this.supportQuotedArguments = supportThem;
            this.init();
        }
    }

    protected void init() {
        HashMap<String, String[]> namedValues = new HashMap<String, String[]>();
        String[] args = this.arguments();
        for (int i = 0; i < args.length; ++i) {
            String option = args[i];
            String value = null;
            if (!this.isOption(option)) continue;
            if (!this.getSwitchAndValuesMustBeSeparated() && option.length() > 2) {
                value = option.substring(2);
                option = option.substring(0, 2);
                this.addOptionWithValue(namedValues, option, this.unquotedIfSupported(value));
            }
            option = args[i];
            ArrayList<String> valueList = new ArrayList<String>();
            if (i < args.length - 1) {
                for (int j = i + 1; j < args.length && !this.isOption(args[j]); ++j) {
                    valueList.add(this.unquotedIfSupported(args[j]));
                }
                if (valueList.isEmpty()) {
                    this.addOptionWithValue(namedValues, option, "");
                    continue;
                }
                this.addOptionWithValues(namedValues, option, valueList);
                continue;
            }
            this.addOptionWithValue(namedValues, option, "");
        }
        this.setOptionsWithValues(namedValues);
    }

    protected void addOptionWithValue(Map<String, String[]> map, String option, String value) {
        if (option != null && value != null) {
            String[] values = map.get(option);
            if (values == null) {
                values = StringUtil.EMPTY_STRING_ARRAY;
            }
            values = this.strUtil().append(values, value);
            map.put(option, values);
        }
    }

    protected void addOptionWithValues(Map<String, String[]> map, String option, List<String> values) {
        for (String value : values) {
            this.addOptionWithValue(map, option, value);
        }
    }

    protected boolean isOption(String arg) {
        return arg.startsWith(this.getSwitchIndicator());
    }

    protected String findOptionValue(String option) {
        String[] values = this.findValues(option);
        if (this.strUtil().isNullOrEmpty(values)) {
            return null;
        }
        return values[0];
    }

    protected String[] findValues(String option) {
        return this.getOptionsWithValues().get(option);
    }

    protected String[] copyOfArguments() {
        String[] result = new String[this.arguments().length];
        for (int i = 0; i < this.arguments().length; ++i) {
            result[i] = this.unquotedIfSupported(this.arguments()[i]);
        }
        return result;
    }

    protected String unquotedIfSupported(String value) {
        if (this.getSupportQuotedArguments()) {
            return this.unquoted(value);
        }
        return value;
    }

    protected String unquoted(String value) {
        if (value.startsWith(QUOTE) && value.endsWith(QUOTE)) {
            return this.strUtil().getDelimitedSubstring(value, QUOTE);
        }
        return value;
    }

    protected String[] arguments() {
        return this.arguments;
    }

    protected void arguments(String[] newValue) {
        this.arguments = newValue;
    }

    protected String switchIndicator() {
        return this.switchIndicator;
    }

    protected void switchIndicator(String newValue) {
        this.switchIndicator = newValue;
    }

    protected Map<String, String[]> getOptionsWithValues() {
        return this.optionsWithValues;
    }

    protected void setOptionsWithValues(Map<String, String[]> newValue) {
        this.optionsWithValues = newValue;
    }

    protected boolean getSwitchAndValuesMustBeSeparated() {
        return this.switchAndValuesMustBeSeparated;
    }

    protected void setSwitchAndValuesMustBeSeparated(boolean newValue) {
        this.switchAndValuesMustBeSeparated = newValue;
    }

    protected StringUtil strUtil() {
        return StringUtil.current();
    }
}

