/*
 * Decompiled with CFR 0.152.
 */
package org.pfsw.text;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import org.pfsw.bif.text.ICheckedCharset;

public class CheckedCharsetName
implements ICheckedCharset,
Serializable {
    private static final long serialVersionUID = 7421658387877543L;
    public static final CheckedCharsetName US_ASCII = CheckedCharsetName.internalCreate("US-ASCII");
    public static final CheckedCharsetName ISO_8859_1 = CheckedCharsetName.internalCreate("ISO-8859-1");
    public static final CheckedCharsetName UTF_8 = CheckedCharsetName.internalCreate("UTF-8");
    public static final CheckedCharsetName UTF_16 = CheckedCharsetName.internalCreate("UTF-16");
    public static final CheckedCharsetName UTF_16BE = CheckedCharsetName.internalCreate("UTF-16BE");
    public static final CheckedCharsetName UTF_16LE = CheckedCharsetName.internalCreate("UTF-16LE");
    public static final CheckedCharsetName DEFAULT = CheckedCharsetName.internalCreate(System.getProperty("file.encoding"));
    private String charsetName;

    public static void checkEncoding(String charsetName) throws UnsupportedEncodingException {
        if (charsetName == null) {
            throw new UnsupportedEncodingException("<null> is no valid charset name!");
        }
        URLEncoder.encode("http://www.programmers-friend.org", charsetName);
    }

    public static CheckedCharsetName create(String encodingName) throws UnsupportedEncodingException {
        return new CheckedCharsetName(encodingName);
    }

    private static CheckedCharsetName internalCreate(String encodingName) {
        try {
            return new CheckedCharsetName(encodingName);
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public CheckedCharsetName(String encodingName) throws UnsupportedEncodingException {
        CheckedCharsetName.checkEncoding(encodingName);
        this.charsetName = encodingName.toUpperCase();
    }

    public String getName() {
        return this.charsetName;
    }

    public Charset getCharset() {
        return Charset.forName(this.getName());
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CheckedCharsetName) {
            CheckedCharsetName checkedName = (CheckedCharsetName)obj;
            return this.getName().equals(checkedName.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String newString(byte[] bytes) {
        try {
            return new String(bytes, this.charsetName);
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    public byte[] getBytes(String string) {
        try {
            return string.getBytes(this.charsetName);
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }
}

