/*
 * Decompiled with CFR 0.152.
 */
package org.pfsw.text;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.pfsw.text.ByteSizeUnit;
import org.pfsw.text.StringPair;
import org.pfsw.text.StringUtil;

public class ByteSizeValue {
    public static final BigDecimal KB_FACTOR = BigDecimal.valueOf(1024L);
    private static final char DECIMAL_SEPARATOR = '.';
    private BigDecimal value;
    private ByteSizeUnit currentUnit;

    public ByteSizeValue(BigDecimal numBytes) {
        this(numBytes, ByteSizeUnit.BYTES);
    }

    public ByteSizeValue(long numBytes) {
        this(BigDecimal.valueOf(numBytes));
    }

    public ByteSizeValue(BigDecimal value, ByteSizeUnit unit) {
        if (value == null) {
            throw new IllegalArgumentException("The provided number of bytes must not be null!");
        }
        if (unit == null) {
            throw new IllegalArgumentException("The provided unit must not be null!");
        }
        this.setValue(value);
        this.setCurrentUnit(unit);
    }

    public ByteSizeValue(long value, ByteSizeUnit unit) {
        this(BigDecimal.valueOf(value), unit);
    }

    public ByteSizeValue(String strValue, ByteSizeUnit defaultUnit) {
        this();
        this.parseAndInit(strValue, defaultUnit);
    }

    public ByteSizeValue(String strValue) {
        this(strValue, ByteSizeUnit.BYTES);
    }

    protected ByteSizeValue() {
        this(0L);
    }

    public long getSizeInBytes() {
        return this.asBytes().longValue();
    }

    public BigDecimal asBytes() {
        return this.convertTo(ByteSizeUnit.BYTES);
    }

    public BigDecimal asKiloBytes() {
        return this.convertTo(ByteSizeUnit.KILO_BYTES);
    }

    public BigDecimal asMegaBytes() {
        return this.convertTo(ByteSizeUnit.MEGA_BYTES);
    }

    public BigDecimal asGigaBytes() {
        return this.convertTo(ByteSizeUnit.GIGA_BYTES);
    }

    public BigDecimal asTeraBytes() {
        return this.convertTo(ByteSizeUnit.TERA_BYTES);
    }

    public BigDecimal asPetaBytes() {
        return this.convertTo(ByteSizeUnit.PETA_BYTES);
    }

    public BigDecimal asExaBytes() {
        return this.convertTo(ByteSizeUnit.EXA_BYTES);
    }

    public BigDecimal convertTo(ByteSizeUnit unit) {
        int precision = 0;
        BigDecimal newValue = this.getValue();
        int powerDiff = this.getCurrentUnit().getPowerOf1024() - unit.getPowerOf1024();
        if (powerDiff < 0) {
            precision = powerDiff *= -1;
            for (int i = 1; i <= powerDiff; ++i) {
                int len = newValue.setScale(0, RoundingMode.HALF_UP).toPlainString().length();
                newValue = newValue.divide(KB_FACTOR);
                if (len >= 5) continue;
                precision += len;
            }
        } else if (powerDiff > 0) {
            for (int i = 1; i <= powerDiff; ++i) {
                newValue = newValue.multiply(KB_FACTOR);
            }
            precision = 0;
        }
        newValue = newValue.setScale(precision, RoundingMode.HALF_UP);
        newValue = newValue.stripTrailingZeros();
        newValue = new BigDecimal(newValue.toPlainString());
        return newValue;
    }

    public String toString() {
        return this.getValue().toPlainString() + " " + this.getCurrentUnit().getIEEE1541Prefix();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ByteSizeValue) {
            ByteSizeValue other = (ByteSizeValue)obj;
            return this.asBytes().equals(other.asBytes());
        }
        return false;
    }

    public int hashCode() {
        return this.asBytes().hashCode();
    }

    protected void parseAndInit(String strValue, ByteSizeUnit defaultUnit) {
        ByteSizeUnit unit = null;
        StringPair stringPair = this.splitDigitsAndUnit(strValue.trim());
        unit = ByteSizeUnit.findByPrefix(stringPair.getString2());
        if (unit == null) {
            if (StringUtil.current().notNullOrEmpty(stringPair.getString2())) {
                throw new NumberFormatException("Invalid byte size unit specified: " + strValue);
            }
            unit = defaultUnit;
        }
        if (unit == ByteSizeUnit.BYTES && StringUtil.current().contains(stringPair.getString1(), '.')) {
            throw new NumberFormatException("Byte size must not contain decimal point for unit 'Bytes': " + strValue);
        }
        this.setValue(new BigDecimal(stringPair.getString1()));
        this.setCurrentUnit(unit);
    }

    protected StringPair splitDigitsAndUnit(String str) {
        int noneDigitIndex = 0;
        StringPair pair = new StringPair();
        for (char ch : str.toCharArray()) {
            if (!Character.isDigit(ch) && ch != '.') break;
            ++noneDigitIndex;
        }
        if (noneDigitIndex >= str.length()) {
            pair.setString1(str);
            pair.setString2("");
        } else {
            pair.setString1(str.substring(0, noneDigitIndex));
            pair.setString2(str.substring(noneDigitIndex).trim());
        }
        return pair;
    }

    protected BigDecimal getValue() {
        return this.value;
    }

    protected void setValue(BigDecimal value) {
        this.value = value;
    }

    protected ByteSizeUnit getCurrentUnit() {
        return this.currentUnit;
    }

    protected void setCurrentUnit(ByteSizeUnit currentUnit) {
        this.currentUnit = currentUnit;
    }
}

