/*
 * Decompiled with CFR 0.152.
 */
package org.pfsw.text;

import java.math.BigDecimal;

public enum ByteSizeUnit {
    BYTES("bytes", "B", "byte", "B", 0),
    KILO_BYTES("kilobytes", "KB", "kibibyte", "KiB", 1),
    MEGA_BYTES("megabytes", "MB", "mebibyte", "MiB", 2),
    GIGA_BYTES("gigabytes", "GB", "gibibyte", "GiB", 3),
    TERA_BYTES("terabytes", "TB", "tebibyte", "TiB", 4),
    PETA_BYTES("petabytes", "PB", "pebibyte", "PiB", 5),
    EXA_BYTES("exabytes", "EB", "exbibyte", "EiB", 6);

    private final int powerOf1024;
    private final String commonName;
    private final String commonPrefix;
    private final String IEEE_1541_Name;
    private final String IEEE_1541_Prefix;
    private final BigDecimal bytesFactor;

    public static ByteSizeUnit findByPrefix(String str) {
        if (str != null) {
            for (ByteSizeUnit unit : ByteSizeUnit.values()) {
                if (unit.getCommonPrefix().equals(str)) {
                    return unit;
                }
                if (!unit.getIEEE1541Prefix().equals(str)) continue;
                return unit;
            }
        }
        return null;
    }

    private ByteSizeUnit(String commonName, String commonPrefix, String IEEE_1541_Name, String IEEE_1541_Prefix, int powerOf1024) {
        this.powerOf1024 = powerOf1024;
        this.commonName = commonName;
        this.commonPrefix = commonPrefix;
        this.IEEE_1541_Name = IEEE_1541_Name;
        this.IEEE_1541_Prefix = IEEE_1541_Prefix;
        this.bytesFactor = this.power(1024L, powerOf1024);
    }

    public int getPowerOf1024() {
        return this.powerOf1024;
    }

    public String getCommonnName() {
        return this.commonName;
    }

    public String getCommonPrefix() {
        return this.commonPrefix;
    }

    public String getIEEE1541Name() {
        return this.IEEE_1541_Name;
    }

    public String getIEEE1541Prefix() {
        return this.IEEE_1541_Prefix;
    }

    public BigDecimal getBytesFactor() {
        return this.bytesFactor;
    }

    public long getFactor() {
        return this.getBytesFactor().longValue();
    }

    private BigDecimal power(long value, int power) {
        long result = 1L;
        for (int i = 1; i <= power; ++i) {
            result *= value;
        }
        return BigDecimal.valueOf(result);
    }
}

