// ===========================================================================
// CONTENT  : INTERFACE JsonType
// AUTHOR   : Manfred Duchrow
// VERSION  : 1.0 - 25/08/2014
// HISTORY  :
//  25/08/2014  mdu  CREATED
//
// Copyright (c) 2014, by MDCS. All rights reserved.
// ===========================================================================
package org.pfsw.text.json;

import org.pfsw.bif.text.IJSONConvertible;
import org.pfsw.bif.text.IStringRepresentation;

/**
 * Common type for top level JSON objects (i.e. Object or Array).  
 *
 * @author Manfred Duchrow
 * @version 1.0
 */
public interface JsonType extends IJSONConvertible, IStringRepresentation
{
  /**
   * Returns true if this is a JSON object representation (in Java).
   */
  public boolean isObject();

  /**
   * Returns true if this is a JSON array representation (in Java).
   */
  public boolean isArray();
}