// ===========================================================================
// CONTENT  : CLASS JsonAccessException
// AUTHOR   : Manfred Duchrow
// VERSION  : 1.0 - 08/01/2017
// HISTORY  :
//  08/01/2017  mdu  CREATED
//
// Copyright (c) 2017, by MDCS. All rights reserved.
// ===========================================================================
package org.pfsw.text.json ;

/**
 * General exception for problems with access to JSON object fields/values.
 *
 * @author Manfred Duchrow
 * @version 1.0
 */
public class JsonAccessException extends RuntimeException
{
  private static final long serialVersionUID = -8458717971552933306L;
  
  // =========================================================================
  // CONSTRUCTORS
  // =========================================================================
  public JsonAccessException(String message, Object...args)
  {
    super(String.format(message, args));
  }

  public JsonAccessException(Throwable cause, String message, Object...args)
  {
    super(String.format(message, args), cause);
  }
}
