// ===========================================================================
// CONTENT  : CLASS CharEscaper
// AUTHOR   : Manfred Duchrow
// VERSION  : 1.0 - 25/08/2014
// HISTORY  :
//  25/08/2014  mdu  CREATED
//
// Copyright (c) 2014, by MDCS. All rights reserved.
// ===========================================================================
package org.pfsw.text.json;

import java.util.HashMap;
// ===========================================================================
// IMPORTS
// ===========================================================================
import java.util.Map;

/**
 * Handles character escaping.
 *
 * @author Manfred Duchrow
 * @version 1.0
 */
class CharEscaper
{
  // =========================================================================
  // CONSTANTS
  // =========================================================================
  private static final Map<Character, Character> CHAR_MAPPING = new HashMap<Character, Character>();

  static
  {
    CHAR_MAPPING.put('"', '"');
    CHAR_MAPPING.put('\\', '\\');
    CHAR_MAPPING.put('/', '/');
    CHAR_MAPPING.put('b', '\b');
    CHAR_MAPPING.put('f', '\f');
    CHAR_MAPPING.put('n', '\n');
    CHAR_MAPPING.put('r', '\r');
    CHAR_MAPPING.put('t', '\t');
  }
  // =========================================================================
  // INSTANCE VARIABLES
  // =========================================================================

  // =========================================================================
  // CONSTRUCTORS
  // =========================================================================
  public CharEscaper()
  {
    super();
  }

  // =========================================================================
  // PUBLIC INSTANCE METHODS
  // =========================================================================
  public char getCharForEscapedChar(final char ch)
  {
    Character newChar;

    newChar = CHAR_MAPPING.get(Character.valueOf(ch));
    if (newChar == null)
    {
      // TODO Support Unicode encoding: \\uXXXX
      return ch;
    }
    return newChar.charValue();
  }
}
