// ===========================================================================
// CONTENT  : INTERFACE StringGenerator
// AUTHOR   : Manfred Duchrow
// VERSION  : 1.0 - 11/10/2014
// HISTORY  :
//  11/10/2014  mdu  CREATED
//
// Copyright (c) 2014, by MDCS. All rights reserved.
// ===========================================================================
package org.pfsw.text;

/**
 * Defines the common API for classes that are supposed to generate strings. 
 *
 * @author Manfred Duchrow
 * @version 1.0
 */
public interface StringGenerator
{
  /**
   * Generates a new string. The contents of the string is implementation specific.
   * The length depends on the default length defined by the implementor.
   * 
   * @return A new string with the default length.
   */
  public String generateString();

  /**
   * Generates a new string with the specified length. 
   * The contents of the string is implementation specific.
   * The length depends on the default length defined by the implementor.
   * 
   * @param length The length of the string to generate.
   * @return A new string with the given length.
   * @throws IllegalArgumentException if the given length is negative.
   */
  public String generateString(int length);

}