// ===========================================================================
// CONTENT  : ENUM NewLine
// AUTHOR   : Manfred Duchrow
// VERSION  : 1.0 - 14/07/2019
// HISTORY  :
//  14/07/2019  mdu  CREATED
//
// Copyright (c) 2019, by MDCS. All rights reserved.
// ===========================================================================
package org.pfsw.text;

import org.pfsw.bif.enums.IEnumType;

/**
 * Provides new line character sequences for the various operating systems. 
 *
 * @author Manfred Duchrow
 * @version 1.0
 */
public enum NewLine implements IEnumType
{
  /**
   * The Linux new line character LF ("\n").
   */
  LINUX("\n"),
  /**
   * The Macintosh new line character CR ("\r").
   */
  MAC("\r"), 
  /**
   * The Windows new line characters CRLF ("\r\n").
   */
  WINDOWS("\r\n"), 
  /**
   * The new line characters of the current operating system.
   */
  CURRENT_OS(System.getProperty("line.separator"));

  private final String newLineChars;

  private NewLine(String newLineChars)
  {
    this.newLineChars = newLineChars;
  }
  
  @Override
  public String asString()
  {
    return this.newLineChars;
  }
}