// ===========================================================================
// CONTENT  : CLASS NegativeStringFilter
// AUTHOR   : Manfred Duchrow
// VERSION  : 1.1 - 20/03/2016
// HISTORY  :
//  28/08/2012  mdu  CREATED
//  20/03/2016  mdu   changed --> from StringFilter to IStringFilter
//
// Copyright (c) 2012-2016, by MDCS. All rights reserved.
// ===========================================================================
package org.pfsw.text;

// ===========================================================================
// IMPORTS
// ===========================================================================
import org.pfsw.bif.text.IStringFilter;

/**
 * A simple filter that negates the result of its inner string filter.
 *
 * @author Manfred Duchrow
 * @version 1.1
 */
public class NegativeStringFilter extends AStringFilter
{
  // =========================================================================
  // INSTANCE VARIABLES
  // =========================================================================
  private IStringFilter innerFilter = null;

  // =========================================================================
  // CONSTRUCTORS
  // =========================================================================
  /**
   * Initialize the new instance with another filter which it negates.
   * 
   * @param filter The filter to negate (must not be null).
   * @throws IllegalArgumentException if the given filter is null.
   */
  public NegativeStringFilter(IStringFilter filter)
  {
    super();
    if (filter == null)
    {
      throw new IllegalArgumentException("filter must not be null!");
    }
    this.setInnerFilter(filter);
  }

  // =========================================================================
  // PUBLIC INSTANCE METHODS
  // =========================================================================
  @Override
  public boolean matches(String string)
  {
    boolean result;

    result = this.getInnerFilter().matches(string);
    return !result;
  }

  protected IStringFilter getInnerFilter()
  {
    return innerFilter;
  }

  protected void setInnerFilter(IStringFilter newValue)
  {
    innerFilter = newValue;
  }
}
