// ===========================================================================
// CONTENT  : CLASS MatchRuleException
// AUTHOR   : Manfred Duchrow
// VERSION  : 1.0 - 20/12/2004
// HISTORY  :
//  20/12/2004  mdu  CREATED
//
// Copyright (c) 2004, by Manfred Duchrow. All rights reserved.
// ===========================================================================
package org.pfsw.text;

/**
 * The base exception of all exceptions that can occur with match rules.
 *
 * @author Manfred Duchrow
 * @version 1.0
 */
public class MatchRuleException extends Exception
{
  // =========================================================================
  // CONSTANTS
  // =========================================================================
  private static final long serialVersionUID = 7488915948629609783L;

  // =========================================================================
  // CONSTRUCTORS
  // =========================================================================
  /**
   * Initialize the new instance with default values.
   */
  public MatchRuleException()
  {
    super();
  }

  /**
   * Initialize the new instance with with a message and optional arguments.
   */
  public MatchRuleException(String message)
  {
    super(message);
  }
  /**
   * Initialize the new instance with with a message and optional arguments.
   */
  public MatchRuleException(String message, Object... args)
  {
    super(String.format(message, args));
  }
}
