// ===========================================================================
// CONTENT  : ABSTRACT CLASS MatchElement
// AUTHOR   : Manfred Duchrow
// VERSION  : 1.5 - 20/12/2004
// HISTORY  :
//  11/07/2001  duma  CREATED
//  09/10/2001  duma  changed -> Made class public
//  08/01/2002  duma  changed -> Made serializable
//	14/08/2002	duma	changed	-> New constructor with no arguments
//	24/10/2003	duma	added		-> multiCharWildcardMatchesEmptyString(), ignoreCaseInName()
//	20/12/2004	duma	added		-> applyDatatypes()
//
// Copyright (c) 2001-2004, by Manfred Duchrow. All rights reserved.
// ===========================================================================
package org.pfsw.text;

import java.io.Serializable;
import java.util.Map;

/**
 * Implements all common state and behavior of elements in a match rule.
 *
 * @author Manfred Duchrow
 * @version 1.5
 */
public abstract class MatchElement implements Serializable
{
  // =========================================================================
  // CONSTANTS
  // =========================================================================
  private static final long serialVersionUID = 1764280877391804990L;

  // =========================================================================
  // INSTANCE VARIABLES
  // =========================================================================
  private boolean and = true;
  private boolean not = false;

  // =========================================================================
  // CONSTRUCTORS
  // =========================================================================
  /**
   * Initialize the new instance with default values.
   */
  public MatchElement()
  {
    super();
  }

  // =========================================================================
  // PUBLIC INSTANCE METHODS
  // =========================================================================
  public boolean getAnd()
  {
    return this.and;
  }

  public void setAnd(boolean newValue)
  {
    this.and = newValue;
  }

  public boolean getNot()
  {
    return this.not;
  }

  public void setNot(boolean newValue)
  {
    this.not = newValue;
  }

  /**
   * Returns true, if the attributes and their values in the given
   * dictionary comply to the rules of the receiver.
   *
   * @param dictionary The attribute-value pairs that have to be checked against the rules
   */
  public boolean matches(Map<String, ?> dictionary)
  {
    boolean ok = doMatch(dictionary);
    if (getNot())
    {
      return (!ok);
    }
    return ok;
  }

  public boolean isGroup()
  {
    return false;
  }

  public boolean isAttribute()
  {
    return false;
  }

  // =========================================================================
  // PROTECTED INSTANCE METHODS
  // =========================================================================

  protected abstract void multiCharWildcardMatchesEmptyString(boolean yesOrNo);

  protected abstract boolean doMatch(Map<String, ?> dictionary);

  protected abstract void ignoreCaseInName(boolean newValue);

  protected abstract void ignoreCase(boolean ignoreIt);

  protected abstract void apply(MatchRuleVisitor visitor);

  protected abstract void applyDatatypes(Map<String, Class<?>> datatypes) throws MatchRuleException;
}