// ===========================================================================
// CONTENT  : CLASS DefaultStringConverter
// AUTHOR   : Manfred Duchrow
// VERSION  : 1.0 - 25/01/2020
// HISTORY  :
//  25/01/2020  mdu  CREATED
//
// Copyright (c) 2020, by MDCS. All rights reserved.
// ===========================================================================
package org.pfsw.text;

import org.pfsw.bif.conversion.IStringConverter;
import org.pfsw.bif.text.IStringRepresentation;

/**
 * Default string converter for any object. It uses method <code>asString()</code> if
 * the object is an {@link IStringRepresentation}, otherwise <code>toString()</code>. 
 *
 * @author Manfred Duchrow
 * @version 1.0
 */
public class DefaultStringConverter<T> implements IStringConverter<T>
{
  /**
   * Returns a new instance of this class.
   */
  public static <V> DefaultStringConverter<V> create()
  {
    return new DefaultStringConverter<V>();
  }
  
  public DefaultStringConverter()
  {
    super();
  }

  /**
   * Returns the string representation of the given object. 
   * It uses method <code>asString()</code> if the object is an {@link IStringRepresentation}, 
   * otherwise <code>toString()</code>.
   * A null input will return null, too. 
   */
  @Override
  public String convert(T object)
  {
    if (object == null)
    {
      return null;
    }
    if (object instanceof IStringRepresentation)
    {
      IStringRepresentation stringRepresentation = (IStringRepresentation)object;
      return stringRepresentation.asString();
    }
    return object.toString();
  }
}
