// ===========================================================================
// CONTENT  : CLASS CollatorComparator
// AUTHOR   : Manfred Duchrow
// VERSION  : 1.0 - 28/08/2014
// HISTORY  :
//  28/08/2014  mdu  CREATED
//
// Copyright (c) 2014, by MDCS. All rights reserved.
// ===========================================================================
package org.pfsw.text;

import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;

/**
 * A wrapper around a collator which allows to use it as a Comparator<String>
 * rather than a Comparator<Object>.
 *
 * @author Manfred Duchrow
 * @version 1.0
 */
public class CollatorComparator implements Comparator<String>
{
  // =========================================================================
  // INSTANCE VARIABLES
  // =========================================================================
  private final Collator collator;

  // =========================================================================
  // CONSTRUCTORS
  // =========================================================================
  /**
   * Creates a new instance based on a collator for the default locale.
   */
  public CollatorComparator()
  {
    this(Collator.getInstance());
  }

  /**
   * Creates a new instance based on a collator for the given locale.
   */
  public CollatorComparator(Locale locale)
  {
    this(Collator.getInstance(locale));
  }

  /**
   * Creates a new instance based on the given collator.
   * @throws IllegalArgumentException if collator is null.
   */
  public CollatorComparator(Collator collator)
  {
    super();
    if (collator == null)
    {
      throw new IllegalArgumentException("collator must not be null!");
    }
    this.collator = collator;
  }

  // =========================================================================
  // PUBLIC INSTANCE METHODS
  // =========================================================================
  @Override
  public int compare(String str1, String str2)
  {
    return getCollator().compare(str1, str2);
  }

  // =========================================================================
  // PROTECTED INSTANCE METHODS
  // =========================================================================
  protected Collator getCollator()
  {
    return collator;
  }
}
