// ===========================================================================
// CONTENT  : ABSTRACT CLASS BaseMatchRuleParser
// AUTHOR   : Manfred Duchrow
// VERSION  : 1.1 - 04/1272003
// HISTORY  :
//  23/08/2002  duma  CREATED
//	04/12/2003	duma	added		-->	checkExpectedEnd()
//
// Copyright (c) 2002-2003, by Manfred Duchrow. All rights reserved.
// ===========================================================================
package org.pfsw.text;

/**
 * Abstract superclass for parsers that produce a MatchRule from any specific
 * syntax. This class provides some common methods and a instance variables
 * that holds a scanner (StringScanner) which most parsers need.
 *
 * @author Manfred Duchrow
 * @version 1.1
 */
public abstract class BaseMatchRuleParser
{
  // =========================================================================
  // INSTANCE VARIABLES
  // =========================================================================
  private StringScanner scanner = null;

  // =========================================================================
  // CONSTRUCTORS
  // =========================================================================
  /**
   * Initialize the new instance with default values
   */
  public BaseMatchRuleParser()
  {
    super();
  }

  /**
   * Initialize the new instance with the given rule.
   * 
   * @param rule Any rule string the internal scanner should be initialized with
   */
  public BaseMatchRuleParser(String rule)
  {
    this();
    scanner(new StringScanner(rule));
  }

  // =========================================================================
  // PROTECTED INSTANCE METHODS
  // =========================================================================
  /**
   * Returns true, if the given character indicates the end of a scanned string.
   */
  protected boolean atEnd(char ch)
  {
    return (ch == StringScanner.END_REACHED);
  }

  protected void checkUnexpectedEnd(char ch) throws MatchRuleParseException
  {
    if (atEnd(ch))
      throwException("Unexpected end of string reached");
  }

  protected void checkExpectedEnd(char ch) throws MatchRuleParseException
  {
    if (!atEnd(ch))
    {
      throwException("Nothing more expected " + "at position " + scanner().getPosition() + ", but found '" + ch + "'");
    }
  }

  protected void throwException(String msg) throws MatchRuleParseException
  {
    MatchRuleParseException exception;

    exception = new MatchRuleParseException(msg);
    exception.setPosition(scanner().getPosition());
    exception.setParseString(scanner().toString());
    throw exception;
  }

  protected StringScanner scanner()
  {
    return scanner;
  }

  protected void scanner(StringScanner newValue)
  {
    scanner = newValue;
  }

  protected StringUtil str()
  {
    return StringUtil.current();
  }

}