// ===========================================================================
// CONTENT  : ABSTRACT CLASS AStringFilter
// AUTHOR   : M.Duchrow
// VERSION  : 1.1 - 20/03/2016
// HISTORY  :
//  24/02/2006  mdu  CREATED
//  20/03/2016  mdu   changed --> from StringFilter to IStringFilter
//
// Copyright (c) 2006-2016, by M.Duchrow. All rights reserved.
// ===========================================================================
package org.pfsw.text;

// ===========================================================================
// IMPORTS
// ===========================================================================
import org.pfsw.bif.filter.IObjectFilter;
import org.pfsw.bif.text.IStringFilter;

/**
 * Subclasses of this abstract string filter class usually must override
 * only method matches(String).
 * This abstract class ensures that filters can be used with any mechanism
 * based on either org.pf.text.ObjectFilter or org.pf.bif.IObjectFilter.
 *
 * @author M.Duchrow
 * @version 1.1
 */
public abstract class AStringFilter implements IStringFilter, IObjectFilter<String>
{
  public AStringFilter()
  {
    super();
  }
}
