/*
 * Decompiled with CFR 0.152.
 */
package org.pengyr.tool.models;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.ArrayMap;
import java.util.Collection;
import org.pengyr.tool.models.KeyModel;
import org.pengyr.tool.models.exception.DataNotFoundException;

public class KeyModelContainer<K, M extends KeyModel<K>> {
    protected ArrayMap<K, M> objectDict = new ArrayMap();

    protected KeyModelContainer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean has(@NonNull K k) {
        KeyModelContainer keyModelContainer = this;
        synchronized (keyModelContainer) {
            return this.objectDict.containsKey(k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public synchronized M get(@NonNull K k) {
        KeyModelContainer keyModelContainer = this;
        synchronized (keyModelContainer) {
            if (!this.objectDict.containsKey(k)) {
                throw new DataNotFoundException(k.toString());
            }
            return (M)((KeyModel)this.objectDict.get(k));
        }
    }

    public synchronized M get(@NonNull K k, @Nullable M m) {
        try {
            return this.get(k);
        }
        catch (DataNotFoundException dataNotFoundException) {
            return m;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(@NonNull M m, boolean bl) {
        KeyModelContainer keyModelContainer = this;
        synchronized (keyModelContainer) {
            if (bl && this.has(m.getID())) {
                return;
            }
            this.objectDict.put(m.getID(), m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(@NonNull M m) {
        KeyModelContainer keyModelContainer = this;
        synchronized (keyModelContainer) {
            this.objectDict.put(m.getID(), m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(@NonNull Collection<M> collection) {
        KeyModelContainer keyModelContainer = this;
        synchronized (keyModelContainer) {
            for (KeyModel keyModel : collection) {
                this.add(keyModel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void delete(@NonNull K k) {
        KeyModelContainer keyModelContainer = this;
        synchronized (keyModelContainer) {
            this.objectDict.remove(k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void delete(@NonNull M m) {
        KeyModelContainer keyModelContainer = this;
        synchronized (keyModelContainer) {
            this.delete((M)m.getID());
        }
    }

    public synchronized int size() {
        return this.objectDict.values().size();
    }

    public void clear() {
        this.objectDict.clear();
    }
}

