/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import org.pcap4j.packet.IllegalPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.IpV6Packet;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.ProtocolFamily;

public final class StaticProtocolFamilyPacketFactory
implements PacketFactory<Packet, ProtocolFamily> {
    private static final StaticProtocolFamilyPacketFactory INSTANCE = new StaticProtocolFamilyPacketFactory();

    private StaticProtocolFamilyPacketFactory() {
    }

    public static StaticProtocolFamilyPacketFactory getInstance() {
        return INSTANCE;
    }

    public Packet newInstance(byte[] rawData, int offset, int length) {
        return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
    }

    public Packet newInstance(byte[] rawData, int offset, int length, ProtocolFamily number) {
        try {
            if (number == ProtocolFamily.PF_INET) {
                return IpV4Packet.newPacket((byte[])rawData, (int)offset, (int)length);
            }
            if (number == ProtocolFamily.PF_INET6) {
                return IpV6Packet.newPacket((byte[])rawData, (int)offset, (int)length);
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }

    public Packet newInstance(byte[] rawData, int offset, int length, ProtocolFamily number1, ProtocolFamily number2) {
        try {
            if (number1 == ProtocolFamily.PF_INET) {
                return IpV4Packet.newPacket((byte[])rawData, (int)offset, (int)length);
            }
            if (number1 == ProtocolFamily.PF_INET6) {
                return IpV6Packet.newPacket((byte[])rawData, (int)offset, (int)length);
            }
            if (number2 == ProtocolFamily.PF_INET) {
                return IpV4Packet.newPacket((byte[])rawData, (int)offset, (int)length);
            }
            if (number2 == ProtocolFamily.PF_INET6) {
                return IpV6Packet.newPacket((byte[])rawData, (int)offset, (int)length);
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }

    public Packet newInstance(byte[] rawData, int offset, int length, ProtocolFamily ... numbers) {
        try {
            for (ProtocolFamily num : numbers) {
                if (num == ProtocolFamily.PF_INET) {
                    return IpV4Packet.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                if (num != ProtocolFamily.PF_INET6) continue;
                return IpV6Packet.newPacket((byte[])rawData, (int)offset, (int)length);
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }
}

