/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import org.pcap4j.packet.IcmpV6DestinationUnreachablePacket;
import org.pcap4j.packet.IcmpV6EchoReplyPacket;
import org.pcap4j.packet.IcmpV6EchoRequestPacket;
import org.pcap4j.packet.IcmpV6NeighborAdvertisementPacket;
import org.pcap4j.packet.IcmpV6NeighborSolicitationPacket;
import org.pcap4j.packet.IcmpV6PacketTooBigPacket;
import org.pcap4j.packet.IcmpV6ParameterProblemPacket;
import org.pcap4j.packet.IcmpV6RedirectPacket;
import org.pcap4j.packet.IcmpV6RouterAdvertisementPacket;
import org.pcap4j.packet.IcmpV6RouterSolicitationPacket;
import org.pcap4j.packet.IcmpV6TimeExceededPacket;
import org.pcap4j.packet.IllegalPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.IcmpV6Type;

public final class StaticIcmpV6TypePacketFactory
implements PacketFactory<Packet, IcmpV6Type> {
    private static final StaticIcmpV6TypePacketFactory INSTANCE = new StaticIcmpV6TypePacketFactory();

    private StaticIcmpV6TypePacketFactory() {
    }

    public static StaticIcmpV6TypePacketFactory getInstance() {
        return INSTANCE;
    }

    public Packet newInstance(byte[] rawData, int offset, int length) {
        return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
    }

    public Packet newInstance(byte[] rawData, int offset, int length, IcmpV6Type number) {
        try {
            switch (Byte.toUnsignedInt((Byte)number.value())) {
                case 1: {
                    return IcmpV6DestinationUnreachablePacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 2: {
                    return IcmpV6PacketTooBigPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 3: {
                    return IcmpV6TimeExceededPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 4: {
                    return IcmpV6ParameterProblemPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 128: {
                    return IcmpV6EchoRequestPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 129: {
                    return IcmpV6EchoReplyPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 133: {
                    return IcmpV6RouterSolicitationPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 134: {
                    return IcmpV6RouterAdvertisementPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 135: {
                    return IcmpV6NeighborSolicitationPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 136: {
                    return IcmpV6NeighborAdvertisementPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 137: {
                    return IcmpV6RedirectPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }

    public Packet newInstance(byte[] rawData, int offset, int length, IcmpV6Type number1, IcmpV6Type number2) {
        try {
            switch (Byte.toUnsignedInt((Byte)number1.value())) {
                case 1: {
                    return IcmpV6DestinationUnreachablePacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 2: {
                    return IcmpV6PacketTooBigPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 3: {
                    return IcmpV6TimeExceededPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 4: {
                    return IcmpV6ParameterProblemPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 128: {
                    return IcmpV6EchoRequestPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 129: {
                    return IcmpV6EchoReplyPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 133: {
                    return IcmpV6RouterSolicitationPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 134: {
                    return IcmpV6RouterAdvertisementPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 135: {
                    return IcmpV6NeighborSolicitationPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 136: {
                    return IcmpV6NeighborAdvertisementPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 137: {
                    return IcmpV6RedirectPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            switch (Byte.toUnsignedInt((Byte)number2.value())) {
                case 1: {
                    return IcmpV6DestinationUnreachablePacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 2: {
                    return IcmpV6PacketTooBigPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 3: {
                    return IcmpV6TimeExceededPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 4: {
                    return IcmpV6ParameterProblemPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 128: {
                    return IcmpV6EchoRequestPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 129: {
                    return IcmpV6EchoReplyPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 133: {
                    return IcmpV6RouterSolicitationPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 134: {
                    return IcmpV6RouterAdvertisementPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 135: {
                    return IcmpV6NeighborSolicitationPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 136: {
                    return IcmpV6NeighborAdvertisementPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 137: {
                    return IcmpV6RedirectPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }

    public Packet newInstance(byte[] rawData, int offset, int length, IcmpV6Type ... numbers) {
        try {
            for (IcmpV6Type num : numbers) {
                switch (Byte.toUnsignedInt((Byte)num.value())) {
                    case 1: {
                        return IcmpV6DestinationUnreachablePacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 2: {
                        return IcmpV6PacketTooBigPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 3: {
                        return IcmpV6TimeExceededPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 4: {
                        return IcmpV6ParameterProblemPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 128: {
                        return IcmpV6EchoRequestPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 129: {
                        return IcmpV6EchoReplyPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 133: {
                        return IcmpV6RouterSolicitationPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 134: {
                        return IcmpV6RouterAdvertisementPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 135: {
                        return IcmpV6NeighborSolicitationPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 136: {
                        return IcmpV6NeighborAdvertisementPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 137: {
                        return IcmpV6RedirectPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                }
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }
}

