/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import org.pcap4j.packet.Dot11ProbeRequestPacket;
import org.pcap4j.packet.IllegalPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.Dot11FrameType;

public final class StaticDot11FrameTypePacketFactory
implements PacketFactory<Packet, Dot11FrameType> {
    private static final StaticDot11FrameTypePacketFactory INSTANCE = new StaticDot11FrameTypePacketFactory();

    private StaticDot11FrameTypePacketFactory() {
    }

    public static StaticDot11FrameTypePacketFactory getInstance() {
        return INSTANCE;
    }

    public Packet newInstance(byte[] rawData, int offset, int length) {
        return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
    }

    public Packet newInstance(byte[] rawData, int offset, int length, Dot11FrameType number) {
        try {
            switch (Byte.toUnsignedInt((Byte)number.value())) {
                case 4: {
                    return Dot11ProbeRequestPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }

    public Packet newInstance(byte[] rawData, int offset, int length, Dot11FrameType number1, Dot11FrameType number2) {
        try {
            switch (Byte.toUnsignedInt((Byte)number1.value())) {
                case 4: {
                    return Dot11ProbeRequestPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            switch (Byte.toUnsignedInt((Byte)number2.value())) {
                case 4: {
                    return Dot11ProbeRequestPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }

    public Packet newInstance(byte[] rawData, int offset, int length, Dot11FrameType ... numbers) {
        try {
            for (Dot11FrameType num : numbers) {
                switch (Byte.toUnsignedInt((Byte)num.value())) {
                    case 4: {
                        return Dot11ProbeRequestPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                }
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }
}

