/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import org.pcap4j.packet.DnsPacket;
import org.pcap4j.packet.GtpSelector;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.AbstractStaticPacketFactory;
import org.pcap4j.packet.factory.PacketInstantiater;
import org.pcap4j.packet.namednumber.UdpPort;

public final class StaticUdpPortPacketFactory
extends AbstractStaticPacketFactory<UdpPort> {
    private static final StaticUdpPortPacketFactory INSTANCE = new StaticUdpPortPacketFactory();

    private StaticUdpPortPacketFactory() {
        this.instantiaters.put(UdpPort.GTP_C, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return GtpSelector.newPacket((byte[])rawData, (int)offset, (int)length);
            }

            public Class<GtpSelector> getTargetClass() {
                return GtpSelector.class;
            }
        });
        this.instantiaters.put(UdpPort.GTP_U, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return GtpSelector.newPacket((byte[])rawData, (int)offset, (int)length);
            }

            public Class<GtpSelector> getTargetClass() {
                return GtpSelector.class;
            }
        });
        this.instantiaters.put(UdpPort.GTP_PRIME, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return GtpSelector.newPacket((byte[])rawData, (int)offset, (int)length);
            }

            public Class<GtpSelector> getTargetClass() {
                return GtpSelector.class;
            }
        });
        this.instantiaters.put(UdpPort.DOMAIN, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return DnsPacket.newPacket((byte[])rawData, (int)offset, (int)length);
            }

            public Class<DnsPacket> getTargetClass() {
                return DnsPacket.class;
            }
        });
    }

    public static StaticUdpPortPacketFactory getInstance() {
        return INSTANCE;
    }
}

