/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import org.pcap4j.packet.CompressedPacket;
import org.pcap4j.packet.EncryptedPacket;
import org.pcap4j.packet.FragmentedPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV6ExtUnknownPacket;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.factory.AbstractStaticPacketFactory;
import org.pcap4j.packet.factory.PacketInstantiater;
import org.pcap4j.packet.namednumber.NotApplicable;

public final class StaticNotApplicablePacketFactory
extends AbstractStaticPacketFactory<NotApplicable> {
    private static final StaticNotApplicablePacketFactory INSTANCE = new StaticNotApplicablePacketFactory();

    private StaticNotApplicablePacketFactory() {
        this.instantiaters.put(NotApplicable.UNKNOWN, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
            }

            public Class<UnknownPacket> getTargetClass() {
                return UnknownPacket.class;
            }
        });
        this.instantiaters.put(NotApplicable.FRAGMENTED, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return FragmentedPacket.newPacket((byte[])rawData, (int)offset, (int)length);
            }

            public Class<FragmentedPacket> getTargetClass() {
                return FragmentedPacket.class;
            }
        });
        this.instantiaters.put(NotApplicable.UNKNOWN_IP_V6_EXTENSION, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return IpV6ExtUnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
            }

            public Class<IpV6ExtUnknownPacket> getTargetClass() {
                return IpV6ExtUnknownPacket.class;
            }
        });
        this.instantiaters.put(NotApplicable.COMPRESSED, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return CompressedPacket.newPacket((byte[])rawData, (int)offset, (int)length);
            }

            public Class<CompressedPacket> getTargetClass() {
                return CompressedPacket.class;
            }
        });
        this.instantiaters.put(NotApplicable.ENCRYPTED, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return EncryptedPacket.newPacket((byte[])rawData, (int)offset, (int)length);
            }

            public Class<EncryptedPacket> getTargetClass() {
                return EncryptedPacket.class;
            }
        });
    }

    public static StaticNotApplicablePacketFactory getInstance() {
        return INSTANCE;
    }
}

