/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.IcmpV6CommonPacket;
import org.pcap4j.packet.IpV4InternetTimestampOption;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.IpV6ExtOptionsPacket;
import org.pcap4j.packet.IpV6ExtRoutingPacket;
import org.pcap4j.packet.IpV6Packet;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.RadiotapPacket;
import org.pcap4j.packet.SctpPacket;
import org.pcap4j.packet.TcpPacket;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.factory.StaticDataLinkTypePacketFactory;
import org.pcap4j.packet.factory.StaticDot11FrameTypePacketFactory;
import org.pcap4j.packet.factory.StaticEtherTypePacketFactory;
import org.pcap4j.packet.factory.StaticIcmpV4TypePacketFactory;
import org.pcap4j.packet.factory.StaticIcmpV6TypePacketFactory;
import org.pcap4j.packet.factory.StaticIpNumberPacketFactory;
import org.pcap4j.packet.factory.StaticIpV4InternetTimestampOptionDataFactory;
import org.pcap4j.packet.factory.StaticIpV4OptionFactory;
import org.pcap4j.packet.factory.StaticIpV4TosFactory;
import org.pcap4j.packet.factory.StaticIpV6FlowLabelFactory;
import org.pcap4j.packet.factory.StaticIpV6NeighborDiscoveryOptionFactory;
import org.pcap4j.packet.factory.StaticIpV6OptionFactory;
import org.pcap4j.packet.factory.StaticIpV6RoutingDataFactory;
import org.pcap4j.packet.factory.StaticIpV6TrafficClassFactory;
import org.pcap4j.packet.factory.StaticLlcNumberPacketFactory;
import org.pcap4j.packet.factory.StaticNotApplicablePacketFactory;
import org.pcap4j.packet.factory.StaticPppDllProtocolPacketFactory;
import org.pcap4j.packet.factory.StaticProtocolFamilyPacketFactory;
import org.pcap4j.packet.factory.StaticRadiotapDataFieldFactory;
import org.pcap4j.packet.factory.StaticSctpChunkFactory;
import org.pcap4j.packet.factory.StaticSctpPortPacketFactory;
import org.pcap4j.packet.factory.StaticTcpOptionFactory;
import org.pcap4j.packet.factory.StaticTcpPortPacketFactory;
import org.pcap4j.packet.factory.StaticUdpPortPacketFactory;
import org.pcap4j.packet.factory.StaticUnknownPacketFactory;
import org.pcap4j.packet.namednumber.DataLinkType;
import org.pcap4j.packet.namednumber.Dot11FrameType;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.IcmpV4Type;
import org.pcap4j.packet.namednumber.IcmpV6Type;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.LlcNumber;
import org.pcap4j.packet.namednumber.NamedNumber;
import org.pcap4j.packet.namednumber.NotApplicable;
import org.pcap4j.packet.namednumber.PppDllProtocol;
import org.pcap4j.packet.namednumber.ProtocolFamily;
import org.pcap4j.packet.namednumber.SctpPort;
import org.pcap4j.packet.namednumber.TcpPort;
import org.pcap4j.packet.namednumber.UdpPort;

final class PacketFactoryBinder {
    private static final PacketFactoryBinder INSTANCE = new PacketFactoryBinder();
    private final Map<Class<? extends NamedNumber<?, ?>>, PacketFactory<?, ?>> packetFactories = new HashMap();
    private final Map<Class<?>, PacketFactory<?, ?>> packetpPieceFactories = new HashMap();

    private PacketFactoryBinder() {
        this.packetFactories.put(DataLinkType.class, StaticDataLinkTypePacketFactory.getInstance());
        this.packetFactories.put(EtherType.class, StaticEtherTypePacketFactory.getInstance());
        this.packetFactories.put(LlcNumber.class, StaticLlcNumberPacketFactory.getInstance());
        this.packetFactories.put(IcmpV4Type.class, StaticIcmpV4TypePacketFactory.getInstance());
        this.packetFactories.put(IcmpV6Type.class, StaticIcmpV6TypePacketFactory.getInstance());
        this.packetFactories.put(IpNumber.class, StaticIpNumberPacketFactory.getInstance());
        this.packetFactories.put(TcpPort.class, StaticTcpPortPacketFactory.getInstance());
        this.packetFactories.put(UdpPort.class, StaticUdpPortPacketFactory.getInstance());
        this.packetFactories.put(SctpPort.class, StaticSctpPortPacketFactory.getInstance());
        this.packetFactories.put(NotApplicable.class, StaticNotApplicablePacketFactory.getInstance());
        this.packetFactories.put(PppDllProtocol.class, StaticPppDllProtocolPacketFactory.getInstance());
        this.packetFactories.put(ProtocolFamily.class, StaticProtocolFamilyPacketFactory.getInstance());
        this.packetFactories.put(Dot11FrameType.class, StaticDot11FrameTypePacketFactory.getInstance());
        this.packetpPieceFactories.put(IpV4Packet.IpV4Option.class, StaticIpV4OptionFactory.getInstance());
        this.packetpPieceFactories.put(IpV4InternetTimestampOption.class, StaticIpV4InternetTimestampOptionDataFactory.getInstance());
        this.packetpPieceFactories.put(TcpPacket.TcpOption.class, StaticTcpOptionFactory.getInstance());
        this.packetpPieceFactories.put(IpV6ExtOptionsPacket.IpV6Option.class, StaticIpV6OptionFactory.getInstance());
        this.packetpPieceFactories.put(IpV6ExtRoutingPacket.IpV6RoutingData.class, StaticIpV6RoutingDataFactory.getInstance());
        this.packetpPieceFactories.put(IcmpV6CommonPacket.IpV6NeighborDiscoveryOption.class, StaticIpV6NeighborDiscoveryOptionFactory.getInstance());
        this.packetpPieceFactories.put(IpV4Packet.IpV4Tos.class, StaticIpV4TosFactory.getInstance());
        this.packetpPieceFactories.put(IpV6Packet.IpV6TrafficClass.class, StaticIpV6TrafficClassFactory.getInstance());
        this.packetpPieceFactories.put(IpV6Packet.IpV6FlowLabel.class, StaticIpV6FlowLabelFactory.getInstance());
        this.packetpPieceFactories.put(RadiotapPacket.RadiotapData.class, StaticRadiotapDataFieldFactory.getInstance());
        this.packetpPieceFactories.put(SctpPacket.SctpChunk.class, StaticSctpChunkFactory.getInstance());
    }

    public static PacketFactoryBinder getInstance() {
        return INSTANCE;
    }

    public <T, N extends NamedNumber<?, ?>> PacketFactory<T, N> getPacketFactory(Class<T> targetClass, Class<N> numberClass) {
        if (Packet.class.isAssignableFrom(targetClass)) {
            PacketFactory<?, ?> factory = this.packetFactories.get(numberClass);
            if (factory != null) {
                return factory;
            }
            return StaticUnknownPacketFactory.getInstance();
        }
        return this.packetpPieceFactories.get(targetClass);
    }
}

