/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpPacket;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.factory.AbstractStaticPacketFactory;
import org.pcap4j.packet.factory.PacketInstantiater;
import org.pcap4j.packet.namednumber.DataLinkType;

public final class StaticDataLinkTypePacketFactory
extends AbstractStaticPacketFactory<DataLinkType> {
    private static final StaticDataLinkTypePacketFactory INSTANCE = new StaticDataLinkTypePacketFactory();

    private StaticDataLinkTypePacketFactory() {
        this.instantiaters.put(DataLinkType.EN10MB, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return EthernetPacket.newPacket((byte[])rawData, (int)offset, (int)length);
            }

            public Class<EthernetPacket> getTargetClass() {
                return EthernetPacket.class;
            }
        });
        this.instantiaters.put(DataLinkType.RAW, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return IpPacket.newPacket((byte[])rawData, (int)offset, (int)length);
            }

            public Class<UnknownPacket> getTargetClass() {
                return UnknownPacket.class;
            }
        });
    }

    public static StaticDataLinkTypePacketFactory getInstance() {
        return INSTANCE;
    }
}

