/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IllegalTcpOption;
import org.pcap4j.packet.TcpEndOfOptionList;
import org.pcap4j.packet.TcpMaximumSegmentSizeOption;
import org.pcap4j.packet.TcpNoOperationOption;
import org.pcap4j.packet.TcpPacket;
import org.pcap4j.packet.UnknownTcpOption;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.TcpOptionKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StaticTcpOptionFactory
implements PacketFactory<TcpPacket.TcpOption, TcpOptionKind> {
    private static final StaticTcpOptionFactory INSTANCE = new StaticTcpOptionFactory();
    private final Map<TcpOptionKind, Instantiater> instantiaters = new HashMap<TcpOptionKind, Instantiater>();

    private StaticTcpOptionFactory() {
        this.instantiaters.put(TcpOptionKind.END_OF_OPTION_LIST, new Instantiater(){

            public TcpPacket.TcpOption newInstance(byte[] rawData) {
                return TcpEndOfOptionList.newInstance((byte[])rawData);
            }
        });
        this.instantiaters.put(TcpOptionKind.NO_OPERATION, new Instantiater(){

            public TcpPacket.TcpOption newInstance(byte[] rawData) {
                return TcpNoOperationOption.newInstance((byte[])rawData);
            }
        });
        this.instantiaters.put(TcpOptionKind.MAXIMUM_SEGMENT_SIZE, new Instantiater(){

            public TcpPacket.TcpOption newInstance(byte[] rawData) {
                return TcpMaximumSegmentSizeOption.newInstance((byte[])rawData);
            }
        });
    }

    public static StaticTcpOptionFactory getInstance() {
        return INSTANCE;
    }

    public TcpPacket.TcpOption newInstance(byte[] rawData, TcpOptionKind number) {
        if (rawData == null || number == null) {
            StringBuilder sb = new StringBuilder(40);
            sb.append("rawData: ").append(rawData).append(" number: ").append(number);
            throw new NullPointerException(sb.toString());
        }
        try {
            Instantiater instantiater = this.instantiaters.get(number);
            if (instantiater != null) {
                return instantiater.newInstance(rawData);
            }
        }
        catch (IllegalRawDataException e) {
            return IllegalTcpOption.newInstance((byte[])rawData);
        }
        return UnknownTcpOption.newInstance((byte[])rawData);
    }

    public TcpPacket.TcpOption newInstance(byte[] rawData) {
        return UnknownTcpOption.newInstance((byte[])rawData);
    }

    private static abstract class Instantiater {
        private Instantiater() {
        }

        public abstract TcpPacket.TcpOption newInstance(byte[] var1);
    }
}

