/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import org.pcap4j.packet.IcmpV4CommonPacket;
import org.pcap4j.packet.IcmpV6CommonPacket;
import org.pcap4j.packet.IpV6ExtDestinationOptionsPacket;
import org.pcap4j.packet.IpV6ExtFragmentPacket;
import org.pcap4j.packet.IpV6ExtHopByHopOptionsPacket;
import org.pcap4j.packet.IpV6ExtRoutingPacket;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.TcpPacket;
import org.pcap4j.packet.UdpPacket;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.factory.AbstractStaticPacketFactory;
import org.pcap4j.packet.factory.PacketInstantiater;
import org.pcap4j.packet.namednumber.IpNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StaticIpNumberPacketFactory
extends AbstractStaticPacketFactory<IpNumber> {
    private static final StaticIpNumberPacketFactory INSTANCE = new StaticIpNumberPacketFactory();

    private StaticIpNumberPacketFactory() {
        this.instantiaters.put(IpNumber.UDP, new PacketInstantiater(){

            public Packet newInstance(byte[] rawData) {
                return UdpPacket.newPacket((byte[])rawData);
            }
        });
        this.instantiaters.put(IpNumber.ICMPV4, new PacketInstantiater(){

            public Packet newInstance(byte[] rawData) {
                return IcmpV4CommonPacket.newPacket((byte[])rawData);
            }
        });
        this.instantiaters.put(IpNumber.ICMPV6, new PacketInstantiater(){

            public Packet newInstance(byte[] rawData) {
                return IcmpV6CommonPacket.newPacket((byte[])rawData);
            }
        });
        this.instantiaters.put(IpNumber.TCP, new PacketInstantiater(){

            public Packet newInstance(byte[] rawData) {
                return TcpPacket.newPacket((byte[])rawData);
            }
        });
        this.instantiaters.put(IpNumber.IPV6_HOPOPT, new PacketInstantiater(){

            public Packet newInstance(byte[] rawData) {
                return IpV6ExtHopByHopOptionsPacket.newPacket((byte[])rawData);
            }
        });
        this.instantiaters.put(IpNumber.IPV6_FRAG, new PacketInstantiater(){

            public Packet newInstance(byte[] rawData) {
                return IpV6ExtFragmentPacket.newPacket((byte[])rawData);
            }
        });
        this.instantiaters.put(IpNumber.IPV6_DST_OPTS, new PacketInstantiater(){

            public Packet newInstance(byte[] rawData) {
                return IpV6ExtDestinationOptionsPacket.newPacket((byte[])rawData);
            }
        });
        this.instantiaters.put(IpNumber.IPV6_ROUTE, new PacketInstantiater(){

            public Packet newInstance(byte[] rawData) {
                return IpV6ExtRoutingPacket.newPacket((byte[])rawData);
            }
        });
        this.instantiaters.put(IpNumber.IPV6_NONXT, new PacketInstantiater(){

            public Packet newInstance(byte[] rawData) {
                return UnknownPacket.newPacket((byte[])rawData);
            }
        });
    }

    public static StaticIpNumberPacketFactory getInstance() {
        return INSTANCE;
    }
}

