/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import org.pcap4j.packet.IcmpV6DestinationUnreachablePacket;
import org.pcap4j.packet.IcmpV6EchoReplyPacket;
import org.pcap4j.packet.IcmpV6EchoRequestPacket;
import org.pcap4j.packet.IcmpV6NeighborAdvertisementPacket;
import org.pcap4j.packet.IcmpV6NeighborSolicitationPacket;
import org.pcap4j.packet.IcmpV6PacketTooBigPacket;
import org.pcap4j.packet.IcmpV6ParameterProblemPacket;
import org.pcap4j.packet.IcmpV6RedirectPacket;
import org.pcap4j.packet.IcmpV6RouterAdvertisementPacket;
import org.pcap4j.packet.IcmpV6RouterSolicitationPacket;
import org.pcap4j.packet.IcmpV6TimeExceededPacket;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.AbstractStaticPacketFactory;
import org.pcap4j.packet.factory.PacketInstantiater;
import org.pcap4j.packet.namednumber.IcmpV6Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StaticIcmpV6TypePacketFactory
extends AbstractStaticPacketFactory<IcmpV6Type> {
    private static final StaticIcmpV6TypePacketFactory INSTANCE = new StaticIcmpV6TypePacketFactory();

    private StaticIcmpV6TypePacketFactory() {
        this.instantiaters.put(IcmpV6Type.DESTINATION_UNREACHABLE, new PacketInstantiater(){

            public Packet newInstance(byte[] rawData) {
                return IcmpV6DestinationUnreachablePacket.newPacket((byte[])rawData);
            }
        });
        this.instantiaters.put(IcmpV6Type.PACKET_TOO_BIG, new PacketInstantiater(){

            public Packet newInstance(byte[] rawData) {
                return IcmpV6PacketTooBigPacket.newPacket((byte[])rawData);
            }
        });
        this.instantiaters.put(IcmpV6Type.TIME_EXCEEDED, new PacketInstantiater(){

            public Packet newInstance(byte[] rawData) {
                return IcmpV6TimeExceededPacket.newPacket((byte[])rawData);
            }
        });
        this.instantiaters.put(IcmpV6Type.PARAMETER_PROBLEM, new PacketInstantiater(){

            public Packet newInstance(byte[] rawData) {
                return IcmpV6ParameterProblemPacket.newPacket((byte[])rawData);
            }
        });
        this.instantiaters.put(IcmpV6Type.ECHO_REQUEST, new PacketInstantiater(){

            public Packet newInstance(byte[] rawData) {
                return IcmpV6EchoRequestPacket.newPacket((byte[])rawData);
            }
        });
        this.instantiaters.put(IcmpV6Type.ECHO_REPLY, new PacketInstantiater(){

            public Packet newInstance(byte[] rawData) {
                return IcmpV6EchoReplyPacket.newPacket((byte[])rawData);
            }
        });
        this.instantiaters.put(IcmpV6Type.ROUTER_SOLICITATION, new PacketInstantiater(){

            public Packet newInstance(byte[] rawData) {
                return IcmpV6RouterSolicitationPacket.newPacket((byte[])rawData);
            }
        });
        this.instantiaters.put(IcmpV6Type.ROUTER_ADVERTISEMENT, new PacketInstantiater(){

            public Packet newInstance(byte[] rawData) {
                return IcmpV6RouterAdvertisementPacket.newPacket((byte[])rawData);
            }
        });
        this.instantiaters.put(IcmpV6Type.NEIGHBOR_SOLICITATION, new PacketInstantiater(){

            public Packet newInstance(byte[] rawData) {
                return IcmpV6NeighborSolicitationPacket.newPacket((byte[])rawData);
            }
        });
        this.instantiaters.put(IcmpV6Type.NEIGHBOR_ADVERTISEMENT, new PacketInstantiater(){

            public Packet newInstance(byte[] rawData) {
                return IcmpV6NeighborAdvertisementPacket.newPacket((byte[])rawData);
            }
        });
        this.instantiaters.put(IcmpV6Type.REDIRECT, new PacketInstantiater(){

            public Packet newInstance(byte[] rawData) {
                return IcmpV6RedirectPacket.newPacket((byte[])rawData);
            }
        });
    }

    public static StaticIcmpV6TypePacketFactory getInstance() {
        return INSTANCE;
    }
}

