/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import org.pcap4j.packet.ArpPacket;
import org.pcap4j.packet.Dot1qVlanTagPacket;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.IpV6Packet;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.AbstractStaticPacketFactory;
import org.pcap4j.packet.factory.PacketInstantiater;
import org.pcap4j.packet.namednumber.EtherType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StaticEtherTypePacketFactory
extends AbstractStaticPacketFactory<EtherType> {
    private static final StaticEtherTypePacketFactory INSTANCE = new StaticEtherTypePacketFactory();

    private StaticEtherTypePacketFactory() {
        this.instantiaters.put(EtherType.IPV4, new PacketInstantiater(){

            public Packet newInstance(byte[] rawData) {
                return IpV4Packet.newPacket((byte[])rawData);
            }
        });
        this.instantiaters.put(EtherType.ARP, new PacketInstantiater(){

            public Packet newInstance(byte[] rawData) {
                return ArpPacket.newPacket((byte[])rawData);
            }
        });
        this.instantiaters.put(EtherType.DOT1Q_VLAN_TAGGED_FRAMES, new PacketInstantiater(){

            public Packet newInstance(byte[] rawData) {
                return Dot1qVlanTagPacket.newPacket((byte[])rawData);
            }
        });
        this.instantiaters.put(EtherType.IPV6, new PacketInstantiater(){

            public Packet newInstance(byte[] rawData) {
                return IpV6Packet.newPacket((byte[])rawData);
            }
        });
    }

    public static StaticEtherTypePacketFactory getInstance() {
        return INSTANCE;
    }
}

