/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.IllegalPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.factory.PacketInstantiater;
import org.pcap4j.packet.namednumber.NamedNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStaticPacketFactory<N extends NamedNumber<?>>
implements PacketFactory<Packet, N> {
    protected final Map<N, PacketInstantiater> instantiaters = new HashMap<N, PacketInstantiater>();

    public Packet newInstance(byte[] rawData, N number) {
        if (rawData == null || number == null) {
            StringBuilder sb = new StringBuilder(40);
            sb.append("rawData: ").append(rawData).append(" number: ").append(number);
            throw new NullPointerException(sb.toString());
        }
        try {
            PacketInstantiater instantiater = this.instantiaters.get(number);
            if (instantiater != null) {
                return instantiater.newInstance(rawData);
            }
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData);
        }
        return UnknownPacket.newPacket((byte[])rawData);
    }

    public Packet newInstance(byte[] rawData) {
        return UnknownPacket.newPacket((byte[])rawData);
    }
}

