/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory.propertiesbased.services;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.factory.PacketFactoryBinder;
import org.pcap4j.packet.factory.propertiesbased.PacketFactoryPropertiesLoader;
import org.pcap4j.packet.factory.propertiesbased.PropertiesBasedPacketFactory;
import org.pcap4j.packet.namednumber.NamedNumber;

final class PropertiesBasedPacketFactoryBinder
implements PacketFactoryBinder {
    private static final PacketFactoryBinder INSTANCE = new PropertiesBasedPacketFactoryBinder();
    private final Map<CacheKey, PacketFactory<?, ?>> cache = new ConcurrentHashMap();

    private PropertiesBasedPacketFactoryBinder() {
    }

    public static PacketFactoryBinder getInstance() {
        return INSTANCE;
    }

    public <T, N extends NamedNumber<?, ?>> PacketFactory<T, N> getPacketFactory(Class<T> targetClass, Class<N> numberClass) {
        if (Packet.class.isAssignableFrom(targetClass)) {
            PropertiesBasedPacketFactory factory = PropertiesBasedPacketFactory.getInstance();
            return factory;
        }
        CacheKey key = new CacheKey(targetClass, numberClass);
        PacketFactory<?, ?> cachedFactory = this.cache.get(key);
        if (cachedFactory != null) {
            return cachedFactory;
        }
        Class<PacketFactory<?, ?>> factoryClass = PacketFactoryPropertiesLoader.getInstance().getPacketFactoryClass(targetClass, numberClass);
        try {
            Method getInstance = factoryClass.getMethod("getInstance", new Class[0]);
            PacketFactory factory = (PacketFactory)getInstance.invoke(null, new Object[0]);
            this.cache.put(key, factory);
            return factory;
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private static final class CacheKey {
        private final Class<?> targetClass;
        private final Class<? extends NamedNumber<?, ?>> numberClass;

        public CacheKey(Class<?> targetClass, Class<? extends NamedNumber<?, ?>> numberClass) {
            this.targetClass = targetClass;
            this.numberClass = numberClass;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return other.numberClass.equals(this.numberClass) && other.targetClass.equals(this.targetClass);
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.targetClass.hashCode();
            result = 31 * result + this.numberClass.hashCode();
            return result;
        }
    }
}

