/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.NamedNumber;

public abstract class AbstractPropertiesBasedFactory<T, N extends NamedNumber<?, ?>>
implements PacketFactory<T, N> {
    public T newInstance(byte[] rawData, int offset, int length, N ... numbers) {
        if (rawData == null) {
            throw new NullPointerException("rawData is null.");
        }
        Class<T> unknown = this.getUnknownClass();
        if (unknown == null) {
            throw new NullPointerException("getUnknownClass() returned null.");
        }
        for (N num : numbers) {
            Class<T> target = this.getTargetClass(num);
            if (target == unknown) continue;
            return this.newInstance(rawData, offset, length, target);
        }
        return this.newInstance(rawData, offset, length, unknown);
    }

    private T newInstance(byte[] rawData, int offset, int length, Class<? extends T> target) {
        if (target == null) {
            throw new NullPointerException("target is null");
        }
        try {
            Method factoryMethod = target.getMethod(this.getStaticFactoryMethodName(), byte[].class, Integer.TYPE, Integer.TYPE);
            Object instance = factoryMethod.invoke(null, rawData, offset, length);
            return (T)instance;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IllegalRawDataException) {
                return this.newIllegalData(rawData, offset, length, (IllegalRawDataException)e.getTargetException());
            }
            throw new IllegalArgumentException(e);
        }
    }

    protected abstract Class<? extends T> getTargetClass(N var1);

    protected abstract Class<? extends T> getUnknownClass();

    protected abstract String getStaticFactoryMethodName();

    protected abstract T newIllegalData(byte[] var1, int var2, int var3, IllegalRawDataException var4);
}

