/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory.propertiesbased;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.pcap4j.packet.IllegalRadiotapData;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.RadiotapPacket;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.factory.propertiesbased.PacketFactoryPropertiesLoader;
import org.pcap4j.packet.namednumber.RadiotapPresentBitNumber;

public final class PropertiesBasedRadiotapDataFactory
implements PacketFactory<RadiotapPacket.RadiotapData, RadiotapPresentBitNumber> {
    private static final PropertiesBasedRadiotapDataFactory INSTANCE = new PropertiesBasedRadiotapDataFactory();

    private PropertiesBasedRadiotapDataFactory() {
    }

    public static PropertiesBasedRadiotapDataFactory getInstance() {
        return INSTANCE;
    }

    public RadiotapPacket.RadiotapData newInstance(byte[] rawData, int offset, int length, RadiotapPresentBitNumber num) {
        return this.newInstance(rawData, offset, length, this.getTargetClass(num));
    }

    public RadiotapPacket.RadiotapData newInstance(byte[] rawData, int offset, int length) {
        return this.newInstance(rawData, offset, length, this.getTargetClass());
    }

    public RadiotapPacket.RadiotapData newInstance(byte[] rawData, int offset, int length, Class<? extends RadiotapPacket.RadiotapData> dataClass) {
        if (rawData == null || dataClass == null) {
            StringBuilder sb = new StringBuilder(50);
            sb.append("rawData: ").append(rawData).append(" dataClass: ").append(dataClass);
            throw new NullPointerException(sb.toString());
        }
        try {
            Method newInstance = dataClass.getMethod("newInstance", byte[].class, Integer.TYPE, Integer.TYPE);
            return (RadiotapPacket.RadiotapData)newInstance.invoke(null, rawData, offset, length);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IllegalRawDataException) {
                return IllegalRadiotapData.newInstance((byte[])rawData, (int)offset, (int)length);
            }
            throw new IllegalArgumentException(e);
        }
    }

    public Class<? extends RadiotapPacket.RadiotapData> getTargetClass(RadiotapPresentBitNumber num) {
        if (num == null) {
            throw new NullPointerException("num must not be null");
        }
        return PacketFactoryPropertiesLoader.getInstance().getRadiotapDataFieldClass(num);
    }

    public Class<? extends RadiotapPacket.RadiotapData> getTargetClass() {
        return PacketFactoryPropertiesLoader.getInstance().getUnknownRadiotapDataFieldClass();
    }
}

