/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.pcap4j.packet.DnsResourceRecord;
import org.pcap4j.packet.IllegalDnsRData;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.factory.PacketFactoryPropertiesLoader;
import org.pcap4j.packet.namednumber.DnsResourceRecordType;

public final class PropertiesBasedDnsRDataFactory
implements PacketFactory<DnsResourceRecord.DnsRData, DnsResourceRecordType> {
    private static final PropertiesBasedDnsRDataFactory INSTANCE = new PropertiesBasedDnsRDataFactory();

    private PropertiesBasedDnsRDataFactory() {
    }

    public static PropertiesBasedDnsRDataFactory getInstance() {
        return INSTANCE;
    }

    public DnsResourceRecord.DnsRData newInstance(byte[] rawData, int offset, int length, DnsResourceRecordType num) {
        return this.newInstance(rawData, offset, length, this.getTargetClass(num));
    }

    public DnsResourceRecord.DnsRData newInstance(byte[] rawData, int offset, int length) {
        return this.newInstance(rawData, offset, length, this.getTargetClass());
    }

    public DnsResourceRecord.DnsRData newInstance(byte[] rawData, int offset, int length, Class<? extends DnsResourceRecord.DnsRData> dataClass) {
        if (rawData == null || dataClass == null) {
            StringBuilder sb = new StringBuilder(50);
            sb.append("rawData: ").append(rawData).append(" dataClass: ").append(dataClass);
            throw new NullPointerException(sb.toString());
        }
        try {
            Method newInstance = dataClass.getMethod("newInstance", byte[].class, Integer.TYPE, Integer.TYPE);
            return (DnsResourceRecord.DnsRData)newInstance.invoke(null, rawData, offset, length);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IllegalRawDataException) {
                return IllegalDnsRData.newInstance((byte[])rawData, (int)offset, (int)length);
            }
            throw new IllegalArgumentException(e);
        }
    }

    public Class<? extends DnsResourceRecord.DnsRData> getTargetClass(DnsResourceRecordType num) {
        if (num == null) {
            throw new NullPointerException("num must not be null");
        }
        return PacketFactoryPropertiesLoader.getInstance().getDnsRDataClass(num);
    }

    public Class<? extends DnsResourceRecord.DnsRData> getTargetClass() {
        return PacketFactoryPropertiesLoader.getInstance().getUnknownDnsRDataClass();
    }
}

