/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IllegalSctpChunk;
import org.pcap4j.packet.SctpPacket;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.factory.PacketFactoryPropertiesLoader;
import org.pcap4j.packet.namednumber.SctpChunkType;

public final class PropertiesBasedSctpChunkFactory
implements PacketFactory<SctpPacket.SctpChunk, SctpChunkType> {
    private static final PropertiesBasedSctpChunkFactory INSTANCE = new PropertiesBasedSctpChunkFactory();

    private PropertiesBasedSctpChunkFactory() {
    }

    public static PropertiesBasedSctpChunkFactory getInstance() {
        return INSTANCE;
    }

    public SctpPacket.SctpChunk newInstance(byte[] rawData, int offset, int length, SctpChunkType number) {
        return this.newInstance(rawData, offset, length, this.getTargetClass(number));
    }

    public SctpPacket.SctpChunk newInstance(byte[] rawData, int offset, int length) {
        return this.newInstance(rawData, offset, length, this.getTargetClass());
    }

    public SctpPacket.SctpChunk newInstance(byte[] rawData, int offset, int length, Class<? extends SctpPacket.SctpChunk> dataClass) {
        if (rawData == null || dataClass == null) {
            StringBuilder sb = new StringBuilder(50);
            sb.append("rawData: ").append(rawData).append(" dataClass: ").append(dataClass);
            throw new NullPointerException(sb.toString());
        }
        try {
            Method newInstance = dataClass.getMethod("newInstance", byte[].class, Integer.TYPE, Integer.TYPE);
            return (SctpPacket.SctpChunk)newInstance.invoke(null, rawData, offset, length);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IllegalRawDataException) {
                return IllegalSctpChunk.newInstance((byte[])rawData, (int)offset, (int)length);
            }
            throw new IllegalArgumentException(e);
        }
    }

    public Class<? extends SctpPacket.SctpChunk> getTargetClass(SctpChunkType number) {
        if (number == null) {
            throw new NullPointerException("number: " + number);
        }
        return PacketFactoryPropertiesLoader.getInstance().getSctpChunkClass(number);
    }

    public Class<? extends SctpPacket.SctpChunk> getTargetClass() {
        return PacketFactoryPropertiesLoader.getInstance().getUnknownSctpChunkClass();
    }
}

