/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IllegalTcpOption;
import org.pcap4j.packet.TcpPacket;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.factory.PacketFactoryPropertiesLoader;
import org.pcap4j.packet.namednumber.TcpOptionKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertiesBasedTcpOptionFactory
implements PacketFactory<TcpPacket.TcpOption, TcpOptionKind> {
    private static final PropertiesBasedTcpOptionFactory INSTANCE = new PropertiesBasedTcpOptionFactory();

    private PropertiesBasedTcpOptionFactory() {
    }

    public static PropertiesBasedTcpOptionFactory getInstance() {
        return INSTANCE;
    }

    public TcpPacket.TcpOption newInstance(byte[] rawData, TcpOptionKind number) {
        if (number == null) {
            throw new NullPointerException(" number: " + number);
        }
        Class<? extends TcpPacket.TcpOption> dataClass = PacketFactoryPropertiesLoader.getInstance().getTcpOptionClass(number);
        return this.newInstance(rawData, dataClass);
    }

    public TcpPacket.TcpOption newInstance(byte[] rawData) {
        Class<? extends TcpPacket.TcpOption> dataClass = PacketFactoryPropertiesLoader.getInstance().getUnknownTcpOptionClass();
        return this.newInstance(rawData, dataClass);
    }

    public TcpPacket.TcpOption newInstance(byte[] rawData, Class<? extends TcpPacket.TcpOption> dataClass) {
        if (rawData == null || dataClass == null) {
            StringBuilder sb = new StringBuilder(50);
            sb.append("rawData: ").append(rawData).append(" dataClass: ").append(dataClass);
            throw new NullPointerException(sb.toString());
        }
        try {
            Method newInstance = dataClass.getMethod("newInstance", byte[].class);
            return (TcpPacket.TcpOption)newInstance.invoke(null, new Object[]{rawData});
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IllegalRawDataException) {
                return IllegalTcpOption.newInstance((byte[])rawData);
            }
            throw new IllegalStateException(e.getTargetException());
        }
    }
}

