/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.DnsDomainName;
import org.pcap4j.packet.DnsResourceRecord;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

public final class DnsRDataMr
implements DnsResourceRecord.DnsRData {
    private static final long serialVersionUID = 3960543085797464866L;
    private final DnsDomainName newName;

    public static DnsRDataMr newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new DnsRDataMr(rawData, offset, length);
    }

    private DnsRDataMr(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.newName = DnsDomainName.newInstance(rawData, offset, length);
    }

    private DnsRDataMr(Builder builder) {
        if (builder == null || builder.newName == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.newName: ").append(builder.newName);
            throw new NullPointerException(sb.toString());
        }
        this.newName = builder.newName;
    }

    public DnsDomainName getNewName() {
        return this.newName;
    }

    @Override
    public int length() {
        return this.newName.length();
    }

    @Override
    public byte[] getRawData() {
        return this.newName.getRawData();
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.convertToString("", null);
    }

    @Override
    public String toString(String indent) {
        return this.convertToString(indent, null);
    }

    @Override
    public String toString(String indent, byte[] headerRawData) {
        if (headerRawData == null) {
            throw new NullPointerException("headerRawData is null.");
        }
        return this.convertToString(indent, headerRawData);
    }

    private String convertToString(String indent, byte[] headerRawData) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("MR RDATA:").append(ls).append(indent).append("  NEWNAME: ").append(this.newName.toString(headerRawData)).append(ls);
        return sb.toString();
    }

    public int hashCode() {
        return this.newName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        DnsRDataMr other = (DnsRDataMr)obj;
        return this.newName.equals(other.newName);
    }

    public static final class Builder {
        private DnsDomainName newName;

        public Builder() {
        }

        private Builder(DnsRDataMr obj) {
            this.newName = obj.newName;
        }

        public Builder newName(DnsDomainName newName) {
            this.newName = newName;
            return this;
        }

        public DnsRDataMr build() {
            return new DnsRDataMr(this);
        }
    }
}

