/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class RadiotapPresentBitNumber
extends NamedNumber<Integer, RadiotapPresentBitNumber> {
    private static final long serialVersionUID = -1778769702168080669L;
    public static final int RADIOTAP_NAMESPACE = 29;
    public static final int VENDOR_NAMESPACE = 30;
    public static final int ANOTHER_BITMAP_FOLLOWS = 31;
    public static final RadiotapPresentBitNumber TSFT = new RadiotapPresentBitNumber(0, "TSFT", 8);
    public static final RadiotapPresentBitNumber FLAGS = new RadiotapPresentBitNumber(1, "Flags", 1);
    public static final RadiotapPresentBitNumber RATE = new RadiotapPresentBitNumber(2, "Rate", 1);
    public static final RadiotapPresentBitNumber CHANNEL = new RadiotapPresentBitNumber(3, "Channel", 2);
    public static final RadiotapPresentBitNumber FHSS = new RadiotapPresentBitNumber(4, "FHSS", 1);
    public static final RadiotapPresentBitNumber ANTENNA_SIGNAL = new RadiotapPresentBitNumber(5, "Antenna signal", 1);
    public static final RadiotapPresentBitNumber ANTENNA_NOISE = new RadiotapPresentBitNumber(6, "Antenna noise", 1);
    public static final RadiotapPresentBitNumber LOCK_QUALITY = new RadiotapPresentBitNumber(7, "Lock quality", 2);
    public static final RadiotapPresentBitNumber TX_ATTENUATION = new RadiotapPresentBitNumber(8, "TX attenuation", 2);
    public static final RadiotapPresentBitNumber DB_TX_ATTENUATION = new RadiotapPresentBitNumber(9, "dB TX attenuation", 2);
    public static final RadiotapPresentBitNumber DBM_TX_POWER = new RadiotapPresentBitNumber(10, "dBm TX power", 1);
    public static final RadiotapPresentBitNumber ANTENNA = new RadiotapPresentBitNumber(11, "Antenna", 1);
    public static final RadiotapPresentBitNumber DB_ANTENNA_SIGNAL = new RadiotapPresentBitNumber(12, "dB antenna signal", 1);
    public static final RadiotapPresentBitNumber DB_ANTENNA_NOISE = new RadiotapPresentBitNumber(13, "dB antenna noise", 1);
    public static final RadiotapPresentBitNumber RX_FLAGS = new RadiotapPresentBitNumber(14, "RX flags", 2);
    public static final RadiotapPresentBitNumber MCS = new RadiotapPresentBitNumber(19, "MCS", 1);
    public static final RadiotapPresentBitNumber A_MPDU_STATUS = new RadiotapPresentBitNumber(20, "A-MPDU status", 4);
    public static final RadiotapPresentBitNumber VHT = new RadiotapPresentBitNumber(21, "VHT", 2);
    private static final Map<String, Map<Integer, RadiotapPresentBitNumber>> registry = new HashMap<String, Map<Integer, RadiotapPresentBitNumber>>();
    private final String namespace;
    private final int requiredAlignment;

    public RadiotapPresentBitNumber(Integer value, String name, int requiredAlignment) {
        this(value, name, "", requiredAlignment);
    }

    public RadiotapPresentBitNumber(Integer value, String name, String namespace, int requiredAlignment) {
        super(value, name);
        if (value % 32 == 29) {
            throw new IllegalArgumentException("Reserved for Radiotap Namespace: " + value);
        }
        if (value % 32 == 30) {
            throw new IllegalArgumentException("Reserved for Vendor Namespace: " + value);
        }
        if (value % 32 == 31) {
            throw new IllegalArgumentException("Reserved for another bitmap follows: " + value);
        }
        this.namespace = namespace;
        this.requiredAlignment = requiredAlignment;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public int getRequiredAlignment() {
        return this.requiredAlignment;
    }

    public static RadiotapPresentBitNumber getInstance(Integer value) {
        return RadiotapPresentBitNumber.getInstance(value, "");
    }

    public static RadiotapPresentBitNumber getInstance(Integer value, String namespace) {
        RadiotapPresentBitNumber num;
        Map<Integer, RadiotapPresentBitNumber> namedRegistry = registry.get(namespace);
        if (namedRegistry != null && (num = namedRegistry.get(value)) != null) {
            return num;
        }
        return new RadiotapPresentBitNumber(value, "unknown", namespace, 1);
    }

    public static RadiotapPresentBitNumber register(RadiotapPresentBitNumber num) {
        String namespace = num.getNamespace();
        Map<Integer, RadiotapPresentBitNumber> namedRegistry = registry.get(namespace);
        if (namedRegistry == null) {
            namedRegistry = new HashMap<Integer, RadiotapPresentBitNumber>();
            registry.put(namespace, namedRegistry);
        }
        return namedRegistry.put((Integer)num.value(), num);
    }

    @Override
    public String valueAsString() {
        if (this.namespace.isEmpty()) {
            return String.valueOf((long)((Integer)this.value()).intValue() & 0xFFFFFFFFL);
        }
        StringBuilder sb = new StringBuilder(30).append(this.namespace).append("/").append((long)((Integer)this.value()).intValue() & 0xFFFFFFFFL);
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        RadiotapPresentBitNumber other = (RadiotapPresentBitNumber)obj;
        return ((Integer)this.value()).equals(other.value()) && this.namespace.equals(other.namespace);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ((Integer)this.value()).hashCode();
        result = 31 * result + this.namespace.hashCode();
        return result;
    }

    @Override
    public int compareTo(RadiotapPresentBitNumber o) {
        return ((Integer)this.value()).compareTo((Integer)o.value());
    }

    static {
        HashMap<Integer, RadiotapPresentBitNumber> defaultRegistry = new HashMap<Integer, RadiotapPresentBitNumber>();
        defaultRegistry.put((Integer)TSFT.value(), TSFT);
        defaultRegistry.put((Integer)FLAGS.value(), FLAGS);
        defaultRegistry.put((Integer)RATE.value(), RATE);
        defaultRegistry.put((Integer)CHANNEL.value(), CHANNEL);
        defaultRegistry.put((Integer)FHSS.value(), FHSS);
        defaultRegistry.put((Integer)ANTENNA_SIGNAL.value(), ANTENNA_SIGNAL);
        defaultRegistry.put((Integer)ANTENNA_NOISE.value(), ANTENNA_NOISE);
        defaultRegistry.put((Integer)LOCK_QUALITY.value(), LOCK_QUALITY);
        defaultRegistry.put((Integer)TX_ATTENUATION.value(), TX_ATTENUATION);
        defaultRegistry.put((Integer)DB_TX_ATTENUATION.value(), DB_TX_ATTENUATION);
        defaultRegistry.put((Integer)DBM_TX_POWER.value(), DBM_TX_POWER);
        defaultRegistry.put((Integer)ANTENNA.value(), ANTENNA);
        defaultRegistry.put((Integer)DB_ANTENNA_SIGNAL.value(), DB_ANTENNA_SIGNAL);
        defaultRegistry.put((Integer)DB_ANTENNA_NOISE.value(), DB_ANTENNA_NOISE);
        defaultRegistry.put((Integer)RX_FLAGS.value(), RX_FLAGS);
        defaultRegistry.put((Integer)MCS.value(), MCS);
        defaultRegistry.put((Integer)A_MPDU_STATUS.value(), A_MPDU_STATUS);
        defaultRegistry.put((Integer)VHT.value(), VHT);
        registry.put("", defaultRegistry);
    }
}

