/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import java.util.Iterator;
import org.pcap4j.packet.BuilderIterator;
import org.pcap4j.packet.PacketIterator;

public interface Packet
extends Iterable<Packet>,
Serializable {
    public Header getHeader();

    public Packet getPayload();

    public int length();

    public byte[] getRawData();

    @Override
    default public Iterator<Packet> iterator() {
        return new PacketIterator(this);
    }

    default public <T extends Packet> T get(Class<T> clazz) {
        for (Packet p : this) {
            if (!clazz.isInstance(p)) continue;
            return (T)((Packet)clazz.cast(p));
        }
        return null;
    }

    default public Packet getLowerLayerOf(Class<? extends Packet> clazz) {
        for (Packet p : this) {
            if (!clazz.isInstance(p.getPayload())) continue;
            return p;
        }
        return null;
    }

    default public <T extends Packet> boolean contains(Class<T> clazz) {
        return this.get(clazz) != null;
    }

    public Builder getBuilder();

    public static interface Header
    extends Serializable {
        public int length();

        public byte[] getRawData();
    }

    public static interface Builder
    extends Iterable<Builder> {
        @Override
        default public Iterator<Builder> iterator() {
            return new BuilderIterator(this);
        }

        default public <T extends Builder> T get(Class<T> clazz) {
            for (Builder b : this) {
                if (!clazz.isInstance(b)) continue;
                return (T)((Builder)clazz.cast(b));
            }
            return null;
        }

        default public Builder getLowerLayerOf(Class<? extends Builder> clazz) {
            for (Builder b : this) {
                if (!clazz.isInstance(b.getPayloadBuilder())) continue;
                return b;
            }
            return null;
        }

        public Builder payloadBuilder(Builder var1);

        public Builder getPayloadBuilder();

        public Packet build();
    }
}

