/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.ChecksumBuilder;
import org.pcap4j.packet.IcmpV6CommonPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IllegalRawDataPacket;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.IpV6NeighborDiscoveryOptionType;
import org.pcap4j.packet.namednumber.NotApplicable;
import org.pcap4j.util.ByteArrays;

public final class IpV6NeighborDiscoveryRedirectedHeaderOption
implements IcmpV6CommonPacket.IpV6NeighborDiscoveryOption {
    private static final long serialVersionUID = 8049779415539820332L;
    private static final int TYPE_OFFSET = 0;
    private static final int TYPE_SIZE = 1;
    private static final int LENGTH_OFFSET = 1;
    private static final int LENGTH_SIZE = 1;
    private static final int RESERVED_OFFSET = 2;
    private static final int RESERVED_SIZE = 6;
    private static final int IP_HEADER_OFFSET = 8;
    private final IpV6NeighborDiscoveryOptionType type = IpV6NeighborDiscoveryOptionType.REDIRECTED_HEADER;
    private final byte length;
    private final byte[] reserved;
    private final Packet ipPacket;

    public static IpV6NeighborDiscoveryRedirectedHeaderOption newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IpV6NeighborDiscoveryRedirectedHeaderOption(rawData, offset, length);
    }

    private IpV6NeighborDiscoveryRedirectedHeaderOption(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 48) {
            StringBuilder sb = new StringBuilder(50);
            sb.append("The raw data length must be more than 47. rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        if (rawData[0 + offset] != (Byte)this.getType().value()) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The type must be: ").append(this.getType().valueAsString()).append(" rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.length = rawData[1 + offset];
        int lengthInByte = this.getLengthAsInt() * 8;
        if (length < lengthInByte) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The raw data is too short to build this option. ").append(lengthInByte).append(" bytes data is needed. data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        if (lengthInByte < 8) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The length field value must be equal or more than").append(1).append("but it is: ").append(this.getLengthAsInt());
            throw new IllegalRawDataException(sb.toString());
        }
        this.reserved = ByteArrays.getSubArray(rawData, 2 + offset, 6);
        Packet p = (Packet)PacketFactories.getFactory(Packet.class, EtherType.class).newInstance(rawData, 8 + offset, lengthInByte - 8, new EtherType[]{EtherType.IPV6});
        if (p instanceof IllegalRawDataPacket) {
            this.ipPacket = p;
            return;
        }
        if (p.contains(IllegalRawDataPacket.class)) {
            Packet.Builder builder = p.getBuilder();
            byte[] ipRawData = p.get(IllegalRawDataPacket.class).getRawData();
            builder.getLowerLayerOf(Packet.Builder.class).payloadBuilder(((Packet)PacketFactories.getFactory(Packet.class, NotApplicable.class).newInstance(ipRawData, 0, ipRawData.length, new NotApplicable[0])).getBuilder());
            for (Packet.Builder b : builder) {
                if (b instanceof LengthBuilder) {
                    ((LengthBuilder)((Object)b)).correctLengthAtBuild(false);
                }
                if (!(b instanceof ChecksumBuilder)) continue;
                ((ChecksumBuilder)((Object)b)).correctChecksumAtBuild(false);
            }
            p = builder.build();
        }
        this.ipPacket = p;
    }

    private IpV6NeighborDiscoveryRedirectedHeaderOption(Builder builder) {
        if (builder == null || builder.reserved == null || builder.ipPacket == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.reserved: ").append(builder.reserved).append(" builder.ipPacket: ").append(builder.ipPacket);
            throw new NullPointerException(sb.toString());
        }
        if (builder.reserved.length != 6) {
            throw new IllegalArgumentException("Invalid reserved: " + ByteArrays.toHexString(builder.reserved, " "));
        }
        this.reserved = ByteArrays.clone(builder.reserved);
        this.ipPacket = builder.ipPacket;
        if (builder.correctLengthAtBuild) {
            if (this.length() % 8 != 0) {
                StringBuilder sb = new StringBuilder();
                sb.append("ipPacket's length is invalid. ipPacket: ").append(ByteArrays.toHexString(this.ipPacket.getRawData(), " "));
                throw new IllegalArgumentException(sb.toString());
            }
            this.length = (byte)(this.length() / 8);
        } else {
            this.length = builder.length;
        }
    }

    @Override
    public IpV6NeighborDiscoveryOptionType getType() {
        return this.type;
    }

    public byte getLength() {
        return this.length;
    }

    public int getLengthAsInt() {
        return 0xFF & this.length;
    }

    public byte[] getReserved() {
        return ByteArrays.clone(this.reserved);
    }

    public Packet getIpPacket() {
        return this.ipPacket;
    }

    @Override
    public int length() {
        return 8 + this.ipPacket.length();
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.getType().value();
        rawData[1] = this.length;
        System.arraycopy(this.reserved, 0, rawData, 2, 6);
        System.arraycopy(this.ipPacket.getRawData(), 0, rawData, 8, this.ipPacket.length());
        return rawData;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Type: ").append(this.getType());
        sb.append("] [Length: ").append(this.getLengthAsInt()).append(" (").append(this.getLengthAsInt() * 8);
        sb.append(" bytes)] [Reserved: ").append(ByteArrays.toHexString(this.reserved, " "));
        sb.append("] [IP header + data: {").append(this.ipPacket);
        sb.append("}]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        IpV6NeighborDiscoveryRedirectedHeaderOption other = (IpV6NeighborDiscoveryRedirectedHeaderOption)obj;
        return this.length == other.length && this.ipPacket.equals(other.ipPacket) && Arrays.equals(this.reserved, other.reserved);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.length;
        result = 31 * result + Arrays.hashCode(this.reserved);
        result = 31 * result + this.ipPacket.hashCode();
        return result;
    }

    public static final class Builder
    implements LengthBuilder<IpV6NeighborDiscoveryRedirectedHeaderOption> {
        private byte length;
        private byte[] reserved;
        private Packet ipPacket;
        private boolean correctLengthAtBuild;

        public Builder() {
        }

        private Builder(IpV6NeighborDiscoveryRedirectedHeaderOption option) {
            this.length = option.length;
            this.reserved = option.reserved;
            this.ipPacket = option.ipPacket;
        }

        public Builder length(byte length) {
            this.length = length;
            return this;
        }

        public Builder reserved(byte[] reserved) {
            this.reserved = reserved;
            return this;
        }

        public Builder ipPacket(Packet ipPacket) {
            this.ipPacket = ipPacket;
            return this;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        @Override
        public IpV6NeighborDiscoveryRedirectedHeaderOption build() {
            return new IpV6NeighborDiscoveryRedirectedHeaderOption(this);
        }
    }
}

