/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.ChecksumBuilder;
import org.pcap4j.packet.IllegalRawDataPacket;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.NotApplicable;

abstract class IcmpV4InvokingPacketPacket
extends AbstractPacket {
    private static final long serialVersionUID = -739710899445035385L;
    private final Packet payload;

    protected IcmpV4InvokingPacketPacket() {
        this.payload = null;
    }

    protected IcmpV4InvokingPacketPacket(byte[] rawData, int payloadOffset, int payloadLength) {
        Packet p = (Packet)PacketFactories.getFactory(Packet.class, EtherType.class).newInstance(rawData, payloadOffset, payloadLength, new EtherType[]{EtherType.IPV4});
        if (p instanceof IllegalRawDataPacket) {
            this.payload = p;
        } else if (p.contains(IllegalRawDataPacket.class)) {
            Packet.Builder builder = p.getBuilder();
            byte[] ipRawData = p.get(IllegalRawDataPacket.class).getRawData();
            builder.getLowerLayerOf(Packet.Builder.class).payloadBuilder(((Packet)PacketFactories.getFactory(Packet.class, NotApplicable.class).newInstance(ipRawData, 0, ipRawData.length, new NotApplicable[]{NotApplicable.UNKNOWN})).getBuilder());
            for (Packet.Builder b : builder) {
                if (b instanceof LengthBuilder) {
                    ((LengthBuilder)((Object)b)).correctLengthAtBuild(false);
                }
                if (!(b instanceof ChecksumBuilder)) continue;
                ((ChecksumBuilder)((Object)b)).correctChecksumAtBuild(false);
            }
            this.payload = builder.build();
        } else {
            this.payload = p;
        }
    }

    protected IcmpV4InvokingPacketPacket(Builder builder) {
        if (builder == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder);
            throw new NullPointerException(sb.toString());
        }
        this.payload = builder.payload;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    static abstract class Builder
    extends AbstractPacket.AbstractBuilder {
        private Packet payload;

        public Builder() {
        }

        protected Builder(IcmpV4InvokingPacketPacket packet) {
            this.payload = packet.payload;
        }

        public Builder payload(Packet payload) {
            this.payload = payload;
            return this;
        }
    }
}

