/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IcmpIdentifiablePacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.NotApplicable;
import org.pcap4j.util.ByteArrays;

public final class IcmpV4EchoReplyPacket
extends IcmpIdentifiablePacket {
    private static final long serialVersionUID = -7353440327689688935L;
    private final IcmpV4EchoReplyHeader header;
    private final Packet payload;

    public static IcmpV4EchoReplyPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IcmpV4EchoReplyPacket(rawData, offset, length);
    }

    private IcmpV4EchoReplyPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new IcmpV4EchoReplyHeader(rawData, offset, length);
        int payloadLength = length - this.header.length();
        this.payload = payloadLength > 0 ? (Packet)PacketFactories.getFactory(Packet.class, NotApplicable.class).newInstance(rawData, offset + this.header.length(), payloadLength, new NotApplicable[]{NotApplicable.UNKNOWN}) : null;
    }

    private IcmpV4EchoReplyPacket(Builder builder) {
        super(builder);
        this.payload = builder.payloadBuilder != null ? builder.payloadBuilder.build() : null;
        this.header = new IcmpV4EchoReplyHeader(builder);
    }

    @Override
    public IcmpV4EchoReplyHeader getHeader() {
        return this.header;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class IcmpV4EchoReplyHeader
    extends IcmpIdentifiablePacket.IcmpIdentifiableHeader {
        private static final long serialVersionUID = 8044479519522316613L;

        private IcmpV4EchoReplyHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            super(rawData, offset, length);
        }

        private IcmpV4EchoReplyHeader(Builder builder) {
            super(builder);
        }

        @Override
        protected String getHeaderName() {
            return "ICMPv4 Echo Reply Header";
        }
    }

    public static final class Builder
    extends IcmpIdentifiablePacket.Builder {
        private Packet.Builder payloadBuilder;

        public Builder() {
        }

        private Builder(IcmpV4EchoReplyPacket packet) {
            super(packet);
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
        }

        @Override
        public Builder identifier(short identifier) {
            super.identifier(identifier);
            return this;
        }

        @Override
        public Builder sequenceNumber(short sequenceNumber) {
            super.sequenceNumber(sequenceNumber);
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        @Override
        public IcmpV4EchoReplyPacket build() {
            return new IcmpV4EchoReplyPacket(this);
        }
    }
}

