/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IllegalRawDataPacket;
import org.pcap4j.util.ByteArrays;

public final class IllegalPacket
extends AbstractPacket
implements IllegalRawDataPacket {
    private static final long serialVersionUID = -8570543867382087471L;
    private final byte[] rawData;
    private final IllegalRawDataException cause;

    public static IllegalPacket newPacket(byte[] rawData, int offset, int length, IllegalRawDataException cause) {
        if (cause == null) {
            throw new NullPointerException("cause is null.");
        }
        ByteArrays.validateBounds(rawData, offset, length);
        return new IllegalPacket(rawData, offset, length, cause);
    }

    private IllegalPacket(byte[] rawData, int offset, int length, IllegalRawDataException cause) {
        this.rawData = new byte[length];
        System.arraycopy(rawData, offset, this.rawData, 0, length);
        this.cause = cause;
    }

    private IllegalPacket(Builder builder) {
        if (builder == null || builder.rawData == null || builder.cause == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.rawData: ").append(builder.rawData).append(" builder.cause").append(builder.cause);
            throw new NullPointerException(sb.toString());
        }
        this.rawData = new byte[builder.rawData.length];
        System.arraycopy(builder.rawData, 0, this.rawData, 0, builder.rawData.length);
        this.cause = builder.cause;
    }

    @Override
    public int length() {
        return this.rawData.length;
    }

    @Override
    public byte[] getRawData() {
        byte[] copy = new byte[this.rawData.length];
        System.arraycopy(this.rawData, 0, copy, 0, copy.length);
        return copy;
    }

    @Override
    public IllegalRawDataException getCause() {
        return this.cause;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    @Override
    protected String buildString() {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append("[Illegal Packet (").append(this.length()).append(" bytes)]").append(ls);
        sb.append("  Hex stream: ").append(ByteArrays.toHexString(this.rawData, " ")).append(ls);
        sb.append("  Cause: ").append(this.cause).append(ls);
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        IllegalPacket other = (IllegalPacket)obj;
        return Arrays.equals(this.rawData, other.rawData) && this.cause.equals(other.cause);
    }

    @Override
    protected int calcHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.cause.hashCode();
        result = 31 * result + Arrays.hashCode(this.rawData);
        return result;
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private byte[] rawData = new byte[0];
        private IllegalRawDataException cause;

        public Builder() {
        }

        private Builder(IllegalPacket packet) {
            this.rawData = packet.rawData;
            this.cause = packet.cause;
        }

        public Builder rawData(byte[] rawData) {
            this.rawData = rawData;
            return this;
        }

        public Builder cause(IllegalRawDataException cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public IllegalPacket build() {
            return new IllegalPacket(this);
        }
    }
}

