/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IllegalRawDataHolder;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.namednumber.IpV4OptionType;
import org.pcap4j.util.ByteArrays;

public final class IllegalIpV4Option
implements IpV4Packet.IpV4Option,
IllegalRawDataHolder {
    private static final long serialVersionUID = -4509427228608202960L;
    private final IpV4OptionType type;
    private final byte[] rawData;
    private final IllegalRawDataException cause;

    public static IllegalIpV4Option newInstance(byte[] rawData, int offset, int length, IllegalRawDataException cause) {
        if (cause == null) {
            throw new NullPointerException("cause is null.");
        }
        ByteArrays.validateBounds(rawData, offset, length);
        return new IllegalIpV4Option(rawData, offset, length, cause);
    }

    private IllegalIpV4Option(byte[] rawData, int offset, int length, IllegalRawDataException cause) {
        this.type = IpV4OptionType.getInstance(rawData[offset]);
        this.rawData = new byte[length];
        System.arraycopy(rawData, offset, this.rawData, 0, length);
        this.cause = cause;
    }

    @Override
    public IpV4OptionType getType() {
        return this.type;
    }

    @Override
    public int length() {
        return this.rawData.length;
    }

    @Override
    public byte[] getRawData() {
        byte[] copy = new byte[this.rawData.length];
        System.arraycopy(this.rawData, 0, copy, 0, copy.length);
        return copy;
    }

    @Override
    public IllegalRawDataException getCause() {
        return this.cause;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[option-type: ").append(this.type).append("] [Illegal Raw Data: 0x").append(ByteArrays.toHexString(this.rawData, "")).append("] [cause: ").append(this.cause).append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.cause.hashCode();
        result = 31 * result + Arrays.hashCode(this.rawData);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IllegalIpV4Option other = (IllegalIpV4Option)obj;
        if (!this.cause.equals(other.cause)) {
            return false;
        }
        return Arrays.equals(this.rawData, other.rawData);
    }
}

