/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.DnsResourceRecord;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IllegalRawDataHolder;
import org.pcap4j.util.ByteArrays;

public final class IllegalDnsRData
implements DnsResourceRecord.DnsRData,
IllegalRawDataHolder {
    private static final long serialVersionUID = 7160504910755325172L;
    private final byte[] rawData;
    private final IllegalRawDataException cause;

    public static IllegalDnsRData newInstance(byte[] rawData, int offset, int length, IllegalRawDataException cause) {
        if (cause == null) {
            throw new NullPointerException("cause is null.");
        }
        ByteArrays.validateBounds(rawData, offset, length);
        return new IllegalDnsRData(rawData, offset, length, cause);
    }

    private IllegalDnsRData(byte[] rawData, int offset, int length, IllegalRawDataException cause) {
        this.rawData = ByteArrays.getSubArray(rawData, offset, length);
        this.cause = cause;
    }

    @Override
    public int length() {
        return this.rawData.length;
    }

    @Override
    public byte[] getRawData() {
        return ByteArrays.clone(this.rawData);
    }

    @Override
    public IllegalRawDataException getCause() {
        return this.cause;
    }

    @Override
    public String toString(String indent) {
        return this.convertToString(indent, null);
    }

    @Override
    public String toString(String indent, byte[] headerRawData) {
        if (headerRawData == null) {
            throw new NullPointerException("headerRawData is null.");
        }
        return this.convertToString(indent, headerRawData);
    }

    private String convertToString(String indent, byte[] headerRawData) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("Illegal Data:").append(ls).append(indent).append("  data: ").append(ByteArrays.toHexString(this.rawData, "")).append(ls).append(indent).append("  cause: ").append(this.cause).append(ls);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.cause.hashCode();
        result = 31 * result + Arrays.hashCode(this.rawData);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IllegalDnsRData other = (IllegalDnsRData)obj;
        if (!this.cause.equals(other.cause)) {
            return false;
        }
        return Arrays.equals(this.rawData, other.rawData);
    }
}

