/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LlcControlInformation;
import org.pcap4j.packet.LlcControlSupervisory;
import org.pcap4j.packet.LlcControlUnnumbered;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.LlcNumber;
import org.pcap4j.util.ByteArrays;

public final class LlcPacket
extends AbstractPacket {
    private static final long serialVersionUID = -4394376906462242290L;
    private final LlcHeader header;
    private final Packet payload;

    public static LlcPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new LlcPacket(rawData, offset, length);
    }

    private LlcPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new LlcHeader(rawData, offset, length);
        int payloadLength = length - this.header.length();
        this.payload = payloadLength > 0 ? (Packet)PacketFactories.getFactory(Packet.class, LlcNumber.class).newInstance(rawData, offset + this.header.length(), payloadLength, new LlcNumber[]{this.header.getDsap()}) : null;
    }

    private LlcPacket(Builder builder) {
        if (builder == null || builder.dsap == null || builder.ssap == null || builder.control == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.dsap: ").append(builder.dsap).append(" builder.ssap: ").append(builder.ssap).append(" builder.control: ").append(builder.control);
            throw new NullPointerException(sb.toString());
        }
        this.payload = builder.payloadBuilder != null ? builder.payloadBuilder.build() : null;
        this.header = new LlcHeader(builder);
    }

    @Override
    public LlcHeader getHeader() {
        return this.header;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static interface LlcControl
    extends Serializable {
        public int length();

        public byte[] getRawData();
    }

    public static final class LlcHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = -6228127495653535606L;
        private static final int DSAP_OFFSET = 0;
        private static final int DSAP_SIZE = 1;
        private static final int SSAP_OFFSET = 1;
        private static final int SSAP_SIZE = 1;
        private static final int CONTROL_OFFSET = 2;
        private final LlcNumber dsap;
        private final LlcNumber ssap;
        private final LlcControl control;

        private LlcHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 3) {
                StringBuilder sb = new StringBuilder(200);
                sb.append("The data is too short to build an LLC header(").append(3).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.dsap = LlcNumber.getInstance(rawData[0 + offset]);
            this.ssap = LlcNumber.getInstance(rawData[1 + offset]);
            byte ctrl = rawData[2 + offset];
            if ((ctrl & 3) == 3) {
                this.control = LlcControlUnnumbered.newInstance(ctrl);
            } else {
                if (length < 4) {
                    StringBuilder sb = new StringBuilder(200);
                    sb.append("The data is too short to build an LLC header(").append(4).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                    throw new IllegalRawDataException(sb.toString());
                }
                this.control = (ctrl & 3) == 1 ? LlcControlSupervisory.newInstance(ByteArrays.getShort(rawData, 2 + offset)) : LlcControlInformation.newInstance(ByteArrays.getShort(rawData, 2 + offset));
            }
        }

        private LlcHeader(Builder builder) {
            this.dsap = builder.dsap;
            this.ssap = builder.ssap;
            this.control = builder.control;
        }

        public LlcNumber getDsap() {
            return this.dsap;
        }

        public LlcNumber getSsap() {
            return this.ssap;
        }

        public LlcControl getControl() {
            return this.control;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray((Byte)this.dsap.value()));
            rawFields.add(ByteArrays.toByteArray((Byte)this.ssap.value()));
            rawFields.add(this.control.getRawData());
            return rawFields;
        }

        @Override
        protected int calcLength() {
            return 2 + this.control.length();
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[Logical Link Control header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  DSAP: ").append(this.dsap).append(ls);
            sb.append("  SSAP: ").append(this.ssap).append(ls);
            sb.append("  Control: ").append(this.control).append(ls);
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            LlcHeader other = (LlcHeader)obj;
            return this.dsap.equals(other.dsap) && this.control.equals(other.control) && this.ssap.equals(other.ssap);
        }

        @Override
        protected int calcHashCode() {
            int result = 17;
            result = 31 * result + this.dsap.hashCode();
            result = 31 * result + this.ssap.hashCode();
            result = 31 * result + this.control.hashCode();
            return result;
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private LlcNumber dsap;
        private LlcNumber ssap;
        private LlcControl control;
        private Packet.Builder payloadBuilder;

        public Builder() {
        }

        private Builder(LlcPacket packet) {
            this.dsap = packet.header.dsap;
            this.ssap = packet.header.ssap;
            this.control = packet.header.control;
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
        }

        public Builder dsap(LlcNumber dsap) {
            this.dsap = dsap;
            return this;
        }

        public Builder ssap(LlcNumber ssap) {
            this.ssap = ssap;
            return this;
        }

        public Builder control(LlcControl control) {
            this.control = control;
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        @Override
        public LlcPacket build() {
            return new LlcPacket(this);
        }
    }
}

