/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.Dot11InformationElement;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.namednumber.Dot11InformationElementId;
import org.pcap4j.util.ByteArrays;

public final class Dot11VendorSpecificElement
extends Dot11InformationElement {
    private static final long serialVersionUID = 2095272309443428672L;
    private final byte[] information;

    public static Dot11VendorSpecificElement newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new Dot11VendorSpecificElement(rawData, offset, length);
    }

    private Dot11VendorSpecificElement(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        super(rawData, offset, length, Dot11InformationElementId.VENDOR_SPECIFIC);
        int infoLen = this.getLengthAsInt();
        this.information = infoLen == 0 ? new byte[0] : ByteArrays.getSubArray(rawData, offset + 2, infoLen);
    }

    private Dot11VendorSpecificElement(Builder builder) {
        super(builder);
        if (builder.information.length > 255) {
            throw new IllegalArgumentException("Too long information: " + builder.information);
        }
        this.information = ByteArrays.clone(builder.information);
    }

    public byte[] getInformation() {
        return ByteArrays.clone(this.information);
    }

    @Override
    public int length() {
        return 2 + this.information.length;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.getElementId().value();
        rawData[1] = this.getLength();
        System.arraycopy(this.information, 0, rawData, 2, this.information.length);
        return rawData;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.information);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        Dot11VendorSpecificElement other = (Dot11VendorSpecificElement)obj;
        return Arrays.equals(this.information, other.information);
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("Vendor Specific:").append(ls);
        sb.append(indent).append("  Element ID: ").append(this.getElementId()).append(ls);
        sb.append(indent).append("  Length: ").append(this.getLengthAsInt()).append(" bytes").append(ls);
        sb.append(indent).append("  Information: 0x").append(ByteArrays.toHexString(this.information, "")).append(ls);
        return sb.toString();
    }

    public static final class Builder
    extends Dot11InformationElement.Builder {
        private byte[] information;

        public Builder() {
            this.elementId(Dot11InformationElementId.getInstance((Byte)Dot11InformationElementId.VENDOR_SPECIFIC.value()));
        }

        private Builder(Dot11VendorSpecificElement elem) {
            super(elem);
            this.information = elem.information;
        }

        public Builder information(byte[] information) {
            this.information = information;
            return this;
        }

        @Override
        public Builder length(byte length) {
            super.length(length);
            return this;
        }

        @Override
        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            super.correctLengthAtBuild(correctLengthAtBuild);
            return this;
        }

        @Override
        public Dot11VendorSpecificElement build() {
            if (this.information == null) {
                throw new NullPointerException("information is null.");
            }
            if (this.getCorrectLengthAtBuild()) {
                this.length((byte)this.information.length);
            }
            return new Dot11VendorSpecificElement(this);
        }
    }
}

