/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.DnsDomainName;
import org.pcap4j.packet.DnsResourceRecord;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

public final class DnsRDataMg
implements DnsResourceRecord.DnsRData {
    private static final long serialVersionUID = 884121664381530886L;
    private final DnsDomainName mgMName;

    public static DnsRDataMg newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new DnsRDataMg(rawData, offset, length);
    }

    private DnsRDataMg(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.mgMName = DnsDomainName.newInstance(rawData, offset, length);
    }

    private DnsRDataMg(Builder builder) {
        if (builder == null || builder.mgMName == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.mgMName: ").append(builder.mgMName);
            throw new NullPointerException(sb.toString());
        }
        this.mgMName = builder.mgMName;
    }

    public DnsDomainName getMgMName() {
        return this.mgMName;
    }

    @Override
    public int length() {
        return this.mgMName.length();
    }

    @Override
    public byte[] getRawData() {
        return this.mgMName.getRawData();
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.convertToString("", null);
    }

    @Override
    public String toString(String indent) {
        return this.convertToString(indent, null);
    }

    @Override
    public String toString(String indent, byte[] headerRawData) {
        if (headerRawData == null) {
            throw new NullPointerException("headerRawData is null.");
        }
        return this.convertToString(indent, headerRawData);
    }

    private String convertToString(String indent, byte[] headerRawData) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("MG RDATA:").append(ls).append(indent).append("  MGMNAME: ").append(this.mgMName.toString(headerRawData)).append(ls);
        return sb.toString();
    }

    public int hashCode() {
        return this.mgMName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        DnsRDataMg other = (DnsRDataMg)obj;
        return this.mgMName.equals(other.mgMName);
    }

    public static final class Builder {
        private DnsDomainName mgMName;

        public Builder() {
        }

        private Builder(DnsRDataMg obj) {
            this.mgMName = obj.mgMName;
        }

        public Builder mgMName(DnsDomainName mgMName) {
            this.mgMName = mgMName;
            return this;
        }

        public DnsRDataMg build() {
            return new DnsRDataMg(this);
        }
    }
}

