/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import java.util.List;
import org.pcap4j.packet.Packet;
import org.pcap4j.util.ByteArrays;
import org.pcap4j.util.LazyValue;

public abstract class AbstractPacket
implements Packet {
    private static final long serialVersionUID = -3016622134481071576L;
    private final LazyValue<Integer> lengthCache = new LazyValue<Integer>(new LazyValue.BuildValueCommand<Integer>(){

        @Override
        public Integer buildValue() {
            return AbstractPacket.this.calcLength();
        }
    });
    private final LazyValue<byte[]> rawDataCache = new LazyValue<byte[]>(new LazyValue.BuildValueCommand<byte[]>(){

        @Override
        public byte[] buildValue() {
            return AbstractPacket.this.buildRawData();
        }
    });
    private final LazyValue<String> hexStringCache = new LazyValue<String>(new LazyValue.BuildValueCommand<String>(){

        @Override
        public String buildValue() {
            return AbstractPacket.this.buildHexString();
        }
    });
    private final LazyValue<String> stringCache = new LazyValue<String>(new LazyValue.BuildValueCommand<String>(){

        @Override
        public String buildValue() {
            return AbstractPacket.this.buildString();
        }
    });
    private final LazyValue<Integer> hashCodeCache = new LazyValue<Integer>(new LazyValue.BuildValueCommand<Integer>(){

        @Override
        public Integer buildValue() {
            return AbstractPacket.this.calcHashCode();
        }
    });

    @Override
    public Packet.Header getHeader() {
        return null;
    }

    @Override
    public Packet getPayload() {
        return null;
    }

    protected int calcLength() {
        int length = 0;
        if (this.getHeader() != null) {
            length += this.getHeader().length();
        }
        if (this.getPayload() != null) {
            length += this.getPayload().length();
        }
        return length;
    }

    @Override
    public int length() {
        return this.lengthCache.getValue();
    }

    protected byte[] buildRawData() {
        byte[] rd = new byte[this.length()];
        Packet.Header header = this.getHeader();
        Packet payload = this.getPayload();
        int dstPos = 0;
        if (header != null) {
            System.arraycopy(this.getHeader().getRawData(), 0, rd, 0, header.length());
            dstPos += header.length();
        }
        if (payload != null) {
            System.arraycopy(this.getPayload().getRawData(), 0, rd, dstPos, payload.length());
            dstPos += payload.length();
        }
        return rd;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = this.rawDataCache.getValue();
        byte[] copy = new byte[rawData.length];
        System.arraycopy(rawData, 0, copy, 0, copy.length);
        return copy;
    }

    @Override
    public abstract Packet.Builder getBuilder();

    protected String buildHexString() {
        return ByteArrays.toHexString(this.getRawData(), " ");
    }

    public String toHexString() {
        return this.hexStringCache.getValue();
    }

    protected String buildString() {
        StringBuilder sb = new StringBuilder();
        if (this.getHeader() != null) {
            sb.append(this.getHeader().toString());
        }
        if (this.getPayload() != null) {
            sb.append(this.getPayload().toString());
        }
        return sb.toString();
    }

    public String toString() {
        return this.stringCache.getValue();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        Packet other = (Packet)obj;
        if (this.getHeader() == null || other.getHeader() == null ? this.getHeader() != null || other.getHeader() != null : !this.getHeader().equals(other.getHeader())) {
            return false;
        }
        if (this.getPayload() == null || other.getPayload() == null) {
            return this.getPayload() == null && other.getPayload() == null;
        }
        return this.getPayload().equals(other.getPayload());
    }

    protected int calcHashCode() {
        int result = 17;
        if (this.getHeader() != null) {
            result = 31 * result + this.getHeader().hashCode();
        }
        if (this.getPayload() != null) {
            result = 31 * result + this.getPayload().hashCode();
        }
        return result;
    }

    public int hashCode() {
        return this.hashCodeCache.getValue();
    }

    public static abstract class AbstractHeader
    implements Packet.Header {
        private static final long serialVersionUID = -8916517326403680608L;
        private final LazyValue<Integer> lengthCache = new LazyValue<Integer>(new LazyValue.BuildValueCommand<Integer>(){

            @Override
            public Integer buildValue() {
                return this.calcLength();
            }
        });
        private final LazyValue<byte[]> rawDataCache = new LazyValue<byte[]>(new LazyValue.BuildValueCommand<byte[]>(){

            @Override
            public byte[] buildValue() {
                return this.buildRawData();
            }
        });
        private final LazyValue<String> hexStringCache = new LazyValue<String>(new LazyValue.BuildValueCommand<String>(){

            @Override
            public String buildValue() {
                return this.buildHexString();
            }
        });
        private final LazyValue<String> stringCache = new LazyValue<String>(new LazyValue.BuildValueCommand<String>(){

            @Override
            public String buildValue() {
                return this.buildString();
            }
        });
        private final LazyValue<Integer> hashCodeCache = new LazyValue<Integer>(new LazyValue.BuildValueCommand<Integer>(){

            @Override
            public Integer buildValue() {
                return this.calcHashCode();
            }
        });

        protected AbstractHeader() {
        }

        protected abstract List<byte[]> getRawFields();

        protected int calcLength() {
            int length = 0;
            for (byte[] rawField : this.getRawFields()) {
                length += rawField.length;
            }
            return length;
        }

        @Override
        public int length() {
            return this.lengthCache.getValue();
        }

        protected byte[] buildRawData() {
            return ByteArrays.concatenate(this.getRawFields());
        }

        @Override
        public byte[] getRawData() {
            byte[] rawData = this.rawDataCache.getValue();
            byte[] copy = new byte[rawData.length];
            System.arraycopy(rawData, 0, copy, 0, copy.length);
            return copy;
        }

        protected String buildHexString() {
            return ByteArrays.toHexString(this.getRawData(), " ");
        }

        public String toHexString() {
            return this.hexStringCache.getValue();
        }

        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[A header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Hex stream: ").append(ByteArrays.toHexString(this.getRawData(), " ")).append(ls);
            return sb.toString();
        }

        public String toString() {
            return this.stringCache.getValue();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            return Arrays.equals(((AbstractHeader)this.getClass().cast(obj)).getRawData(), this.getRawData());
        }

        protected int calcHashCode() {
            return Arrays.hashCode(this.getRawData());
        }

        public int hashCode() {
            return this.hashCodeCache.getValue();
        }
    }

    public static abstract class AbstractBuilder
    implements Packet.Builder {
        @Override
        public AbstractBuilder payloadBuilder(Packet.Builder payloadBuilder) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return null;
        }

        @Override
        public abstract Packet build();
    }
}

