/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.namednumber.IpV4OptionType;
import org.pcap4j.util.ByteArrays;

public final class IllegalIpV4Option
implements IpV4Packet.IpV4Option {
    private static final long serialVersionUID = -5887663161675479542L;
    private final IpV4OptionType type;
    private final byte[] rawData;

    public static IllegalIpV4Option newInstance(byte[] rawData, int offset, int length) {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IllegalIpV4Option(rawData, offset, length);
    }

    private IllegalIpV4Option(byte[] rawData, int offset, int length) {
        this.type = IpV4OptionType.getInstance(rawData[offset]);
        this.rawData = new byte[length];
        System.arraycopy(rawData, offset, this.rawData, 0, length);
    }

    private IllegalIpV4Option(Builder builder) {
        if (builder == null || builder.type == null || builder.rawData == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.type: ").append(builder.type).append(" builder.rawData: ").append(builder.rawData);
            throw new NullPointerException(sb.toString());
        }
        this.type = builder.type;
        this.rawData = new byte[builder.rawData.length];
        System.arraycopy(builder.rawData, 0, this.rawData, 0, builder.rawData.length);
    }

    @Override
    public IpV4OptionType getType() {
        return this.type;
    }

    @Override
    public int length() {
        return this.rawData.length;
    }

    @Override
    public byte[] getRawData() {
        byte[] copy = new byte[this.rawData.length];
        System.arraycopy(this.rawData, 0, copy, 0, copy.length);
        return copy;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[option-type: ").append(this.type).append("] [Illegal Raw Data: 0x").append(ByteArrays.toHexString(this.rawData, "")).append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        IllegalIpV4Option other = (IllegalIpV4Option)obj;
        return this.type.equals(other.type) && Arrays.equals(other.rawData, this.rawData);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.type.hashCode();
        result = 31 * result + Arrays.hashCode(this.rawData);
        return result;
    }

    public static final class Builder {
        private IpV4OptionType type;
        private byte[] rawData;

        public Builder() {
        }

        private Builder(IllegalIpV4Option option) {
            this.type = option.type;
            this.rawData = option.rawData;
        }

        public Builder type(IpV4OptionType type) {
            this.type = type;
            return this;
        }

        public Builder rawData(byte[] rawData) {
            this.rawData = rawData;
            return this;
        }

        public IllegalIpV4Option build() {
            return new IllegalIpV4Option(this);
        }
    }
}

